/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.net;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.net.SyslogAppender;
import ch.qos.logback.classic.net.mock.MockSyslogServer;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.testUtil.RandomUtil;
import ch.qos.logback.core.util.StatusPrinter;
import java.nio.charset.Charset;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.LoggerFactory;

@Ignore
public class SyslogAppenderTest {
    private static final String SYSLOG_PREFIX_REGEX = "<\\d{2}>\\w{3} [\\d ]\\d \\d{2}(:\\d{2}){2} [\\w.-]* ";
    LoggerContext lc = new LoggerContext();
    SyslogAppender sa = new SyslogAppender();
    MockSyslogServer mockServer;
    String loggerName = this.getClass().getName();
    Logger logger = this.lc.getLogger(this.loggerName);

    @Before
    public void setUp() throws Exception {
        this.lc.setName("test");
        this.sa.setContext((Context)this.lc);
    }

    @After
    public void tearDown() throws Exception {
    }

    public void setMockServerAndConfigure(int expectedCount, String suffixPattern) throws InterruptedException {
        int port = RandomUtil.getRandomServerPort();
        this.mockServer = new MockSyslogServer(expectedCount, port);
        this.mockServer.start();
        Thread.sleep(100L);
        this.sa.setSyslogHost("localhost");
        this.sa.setFacility("MAIL");
        this.sa.setPort(port);
        this.sa.setSuffixPattern(suffixPattern);
        this.sa.setStackTracePattern("[%thread] foo \t");
        this.sa.start();
        Assert.assertTrue((boolean)this.sa.isStarted());
        String loggerName = this.getClass().getName();
        Logger logger = this.lc.getLogger(loggerName);
        logger.addAppender((Appender)this.sa);
    }

    public void setMockServerAndConfigure(int expectedCount) throws InterruptedException {
        this.setMockServerAndConfigure(expectedCount, "[%thread] %logger %msg");
    }

    @Test
    public void basic() throws InterruptedException {
        this.setMockServerAndConfigure(1);
        String logMsg = "hello";
        this.logger.debug(logMsg);
        this.mockServer.join(8000L);
        Assert.assertTrue((boolean)this.mockServer.isFinished());
        Assert.assertEquals((long)1L, (long)this.mockServer.getMessageList().size());
        String msg = new String(this.mockServer.getMessageList().get(0));
        String threadName = Thread.currentThread().getName();
        String expected = "<23>";
        Assert.assertTrue((boolean)msg.startsWith(expected));
        this.checkRegexMatch(msg, "<\\d{2}>\\w{3} [\\d ]\\d \\d{2}(:\\d{2}){2} [\\w.-]* \\[" + threadName + "\\] " + this.loggerName + " " + logMsg);
    }

    @Test
    public void suffixPatternWithTag() throws InterruptedException {
        this.setMockServerAndConfigure(1, "test/something [%thread] %logger %msg");
        String logMsg = "hello";
        this.logger.debug(logMsg);
        this.mockServer.join(8000L);
        Assert.assertTrue((boolean)this.mockServer.isFinished());
        Assert.assertEquals((long)1L, (long)this.mockServer.getMessageList().size());
        String msg = new String(this.mockServer.getMessageList().get(0));
        String threadName = Thread.currentThread().getName();
        String expected = "<23>";
        Assert.assertTrue((boolean)msg.startsWith(expected));
        this.checkRegexMatch(msg, "<\\d{2}>\\w{3} [\\d ]\\d \\d{2}(:\\d{2}){2} [\\w.-]* test/something \\[" + threadName + "\\] " + this.loggerName + " " + logMsg);
    }

    @Test
    public void tException() throws InterruptedException {
        this.setMockServerAndConfigure(21);
        String logMsg = "hello";
        String exMsg = "just testing";
        Exception ex = new Exception(exMsg);
        this.logger.debug(logMsg, (Throwable)ex);
        StatusPrinter.print((Context)this.lc);
        this.mockServer.join(8000L);
        Assert.assertTrue((boolean)this.mockServer.isFinished());
        Assert.assertEquals((long)21L, (long)this.mockServer.getMessageList().size());
        String msg = new String(this.mockServer.getMessageList().get(0));
        String expected = "<23>";
        Assert.assertTrue((boolean)msg.startsWith(expected));
        String threadName = Thread.currentThread().getName();
        String regex = "<\\d{2}>\\w{3} [\\d ]\\d \\d{2}(:\\d{2}){2} [\\w.-]* \\[" + threadName + "\\] " + this.loggerName + " " + logMsg;
        this.checkRegexMatch(msg, regex);
        msg = new String(this.mockServer.getMessageList().get(1));
        Assert.assertTrue((boolean)msg.contains(ex.getClass().getName()));
        Assert.assertTrue((boolean)msg.contains(ex.getMessage()));
        msg = new String(this.mockServer.getMessageList().get(2));
        Assert.assertTrue((boolean)msg.startsWith(expected));
        regex = "<\\d{2}>\\w{3} [\\d ]\\d \\d{2}(:\\d{2}){2} [\\w.-]* \\[" + threadName + "\\] foo \tat ch\\.qos.*";
        this.checkRegexMatch(msg, regex);
    }

    private void checkRegexMatch(String s, String regex) {
        Assert.assertTrue((String)("The string [" + s + "] did not match regex [" + regex + "]"), (boolean)s.matches(regex));
    }

    @Test
    public void large() throws Exception {
        this.setMockServerAndConfigure(2);
        StringBuilder largeBuf = new StringBuilder();
        for (int i = 0; i < 0x200000; ++i) {
            largeBuf.append('a');
        }
        this.logger.debug(largeBuf.toString());
        String logMsg = "hello";
        this.logger.debug(logMsg);
        Thread.sleep(30L);
        this.logger.debug(logMsg);
        this.mockServer.join(8000L);
        Assert.assertTrue((boolean)this.mockServer.isFinished());
        Assert.assertEquals((long)2L, (long)this.mockServer.getMessageList().size());
        String expected = "<23>";
        String threadName = Thread.currentThread().getName();
        int maxMessageSize = this.sa.getMaxMessageSize();
        String largeMsg = new String(this.mockServer.getMessageList().get(0));
        Assert.assertTrue((boolean)largeMsg.startsWith(expected));
        String largeRegex = "<\\d{2}>\\w{3} [\\d ]\\d \\d{2}(:\\d{2}){2} [\\w.-]* \\[" + threadName + "\\] " + this.loggerName + " a{" + (maxMessageSize - 2000) + "," + maxMessageSize + "}";
        this.checkRegexMatch(largeMsg, largeRegex);
        String msg = new String(this.mockServer.getMessageList().get(1));
        Assert.assertTrue((boolean)msg.startsWith(expected));
        String regex = "<\\d{2}>\\w{3} [\\d ]\\d \\d{2}(:\\d{2}){2} [\\w.-]* \\[" + threadName + "\\] " + this.loggerName + " " + logMsg;
        this.checkRegexMatch(msg, regex);
    }

    @Test
    public void LBCLASSIC_50() throws JoranException {
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        JoranConfigurator configurator = new JoranConfigurator();
        configurator.setContext((Context)lc);
        lc.reset();
        configurator.doConfigure("src/test/input/joran/syslog_LBCLASSIC_50.xml");
        org.slf4j.Logger logger = LoggerFactory.getLogger(this.getClass());
        logger.info("hello");
    }

    @Test
    public void unknownHostShouldNotCauseStopToFail() {
        this.sa.setSyslogHost("unknown.host");
        this.sa.setFacility("MAIL");
        this.sa.start();
        this.sa.stop();
    }

    @Test
    public void nonAsciiMessageEncoding() throws Exception {
        this.setMockServerAndConfigure(1);
        String logMsg = "R\u0129ga";
        Charset ISO_8859_4 = Charset.forName("ISO-8859-4");
        this.sa.setCharset(ISO_8859_4);
        this.logger.debug(logMsg);
        this.mockServer.join(8000L);
        Assert.assertTrue((boolean)this.mockServer.isFinished());
        Assert.assertEquals((long)1L, (long)this.mockServer.getMessageList().size());
        String msg = new String(this.mockServer.getMessageList().get(0), ISO_8859_4);
        String threadName = Thread.currentThread().getName();
        String expected = "<23>";
        Assert.assertTrue((boolean)msg.startsWith(expected));
        System.out.println(logMsg);
        this.checkRegexMatch(msg, "<\\d{2}>\\w{3} [\\d ]\\d \\d{2}(:\\d{2}){2} [\\w.-]* \\[" + threadName + "\\] " + this.loggerName + " " + logMsg);
    }
}

