/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.testUtil.StatusChecker;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CompositeConverterTest {
    private PatternLayout pl = new PatternLayout();
    private LoggerContext lc = new LoggerContext();
    Logger logger = this.lc.getLogger(this.getClass());
    StatusChecker sc = new StatusChecker((Context)this.lc);

    @Before
    public void setUp() {
        this.pl.setContext((Context)this.lc);
    }

    ILoggingEvent makeLoggingEvent(String msg, Exception ex) {
        return new LoggingEvent(CompositeConverterTest.class.getName(), this.logger, Level.INFO, msg, (Throwable)ex, null);
    }

    @Test
    public void testLogback1582() {
        this.pl.setPattern("%m  %replace(%rootException{5, EVAL_REF}){'\\n', 'XYZ'}\"");
        this.pl.start();
        ILoggingEvent le = this.makeLoggingEvent("assert", new Exception("test"));
        String result = this.pl.doLayout(le);
        this.sc.assertIsErrorFree();
        Assert.assertTrue((boolean)result.contains("XYZ"));
    }
}

