/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.selector;

import ch.qos.logback.classic.selector.ContextJNDISelector;
import ch.qos.logback.classic.selector.servlet.ContextDetachingSCL;
import ch.qos.logback.classic.util.ContextSelectorStaticBinder;
import ch.qos.logback.core.testUtil.MockInitialContext;
import ch.qos.logback.core.testUtil.MockInitialContextFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.LoggerFactory;
import org.slf4j.LoggerFactoryFriend;

@Ignore
public class ContextDetachingSCLTest {
    static String INITIAL_CONTEXT_KEY = "java.naming.factory.initial";
    ContextDetachingSCL contextDetachingSCL;

    @Before
    public void setUp() throws Exception {
        System.setProperty("logback.ContextSelector", "JNDI");
        this.contextDetachingSCL = new ContextDetachingSCL();
        MockInitialContextFactory.initialize();
        MockInitialContext mic = MockInitialContextFactory.getContext();
        mic.map.put("java:comp/env/logback/context-name", "toto");
        System.setProperty(INITIAL_CONTEXT_KEY, MockInitialContextFactory.class.getName());
        LoggerFactoryFriend.reset();
        LoggerFactory.getLogger(ContextDetachingSCLTest.class);
    }

    @After
    public void tearDown() throws Exception {
        System.clearProperty(INITIAL_CONTEXT_KEY);
        LoggerFactoryFriend.reset();
    }

    @Test
    public void testDetach() {
        ContextJNDISelector selector = (ContextJNDISelector)ContextSelectorStaticBinder.getSingleton().getContextSelector();
        this.contextDetachingSCL.contextDestroyed(null);
        Assert.assertEquals((long)0L, (long)selector.getCount());
    }

    @Test
    public void testDetachWithMissingContext() {
        MockInitialContext mic = MockInitialContextFactory.getContext();
        mic.map.put("java:comp/env/logback/context-name", "tata");
        ContextJNDISelector selector = (ContextJNDISelector)ContextSelectorStaticBinder.getSingleton().getContextSelector();
        Assert.assertEquals((Object)"tata", (Object)selector.getLoggerContext().getName());
        mic.map.put("java:comp/env/logback/context-name", "titi");
        Assert.assertEquals((Object)"titi", (Object)selector.getLoggerContext().getName());
        this.contextDetachingSCL.contextDestroyed(null);
        Assert.assertEquals((long)2L, (long)selector.getCount());
    }
}

