/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.spi;

import ch.qos.logback.classic.net.NOPOutputStream;
import ch.qos.logback.classic.net.testObjectBuilders.Builder;
import ch.qos.logback.classic.net.testObjectBuilders.LoggingEventWithParametersBuilder;
import ch.qos.logback.classic.net.testObjectBuilders.TrivialLoggingEventBuilder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.classic.spi.LoggingEventVO;
import ch.qos.logback.core.testUtil.EnvUtilForTests;
import java.io.IOException;
import java.io.ObjectOutputStream;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.MDC;

@Ignore
public class LoggingEventSerializationPerfTest {
    static int LOOP_LEN = 10000;
    NOPOutputStream noos = new NOPOutputStream();
    ObjectOutputStream oos;

    @Before
    public void setUp() throws Exception {
        MDC.clear();
        this.oos = new ObjectOutputStream(this.noos);
    }

    @After
    public void tearDown() throws Exception {
    }

    double doLoop(Builder<LoggingEvent> builder, int loopLen) {
        long start = System.nanoTime();
        int resetCounter = 0;
        for (int i = 0; i < loopLen; ++i) {
            try {
                ILoggingEvent le = (ILoggingEvent)builder.build(i);
                this.oos.writeObject(LoggingEventVO.build((ILoggingEvent)le));
                this.oos.flush();
                if (++resetCounter < 70) continue;
                this.oos.reset();
                resetCounter = 0;
                continue;
            }
            catch (IOException ex) {
                Assert.fail((String)ex.getMessage());
            }
        }
        long end = System.nanoTime();
        return (double)(end - start) / (1.0 * (double)loopLen);
    }

    @Test
    public void testPerformance() {
        if (EnvUtilForTests.isLinux()) {
            return;
        }
        TrivialLoggingEventBuilder builder = new TrivialLoggingEventBuilder();
        for (int i = 0; i < 3; ++i) {
            this.doLoop(builder, LOOP_LEN);
            this.noos.reset();
        }
        double rt = this.doLoop(builder, LOOP_LEN);
        System.out.println("average time per logging event " + rt + " nanoseconds");
        long averageSize = this.noos.size() / (long)LOOP_LEN;
        System.out.println("noos size " + this.noos.size() + " average size=" + averageSize);
        double averageSizeLimit = 62.1;
        Assert.assertTrue((String)("average size " + averageSize + " should be less than " + averageSizeLimit), (averageSizeLimit > (double)averageSize ? 1 : 0) != 0);
        long referencePerf = 5000L;
    }

    @Test
    public void testPerformanceWithParameters() {
        if (EnvUtilForTests.isLinux()) {
            return;
        }
        LoggingEventWithParametersBuilder builder = new LoggingEventWithParametersBuilder();
        for (int i = 0; i < 3; ++i) {
            this.doLoop(builder, LOOP_LEN);
            this.noos.reset();
        }
        double rt = this.doLoop(builder, LOOP_LEN);
        long averageSize = this.noos.size() / (long)LOOP_LEN;
        System.out.println("noos size " + this.noos.size() + " average size=" + averageSize);
        double averageSizeLimit = 160.0;
        Assert.assertTrue((String)("averageSize " + averageSize + " should be less than " + averageSizeLimit), (averageSizeLimit > (double)averageSize ? 1 : 0) != 0);
        long referencePerf = 7000L;
    }
}

