/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.spi;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.LoggingEvent;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LoggingEventTest {
    LoggerContext loggerContext = new LoggerContext();
    Logger logger = this.loggerContext.getLogger("ROOT");

    @Before
    public void setUp() {
    }

    @Test
    public void testFormattingOneArg() {
        String message = "x={}";
        Throwable throwable = null;
        Object[] argArray = new Object[]{12};
        LoggingEvent event = new LoggingEvent("", this.logger, Level.INFO, message, throwable, argArray);
        Assert.assertNull((Object)event.formattedMessage);
        Assert.assertEquals((Object)"x=12", (Object)event.getFormattedMessage());
    }

    @Test
    public void testFormattingTwoArg() {
        String message = "{}-{}";
        Throwable throwable = null;
        Object[] argArray = new Object[]{12, 13};
        LoggingEvent event = new LoggingEvent("", this.logger, Level.INFO, message, throwable, argArray);
        Assert.assertNull((Object)event.formattedMessage);
        Assert.assertEquals((Object)"12-13", (Object)event.getFormattedMessage());
    }

    @Test
    public void testNoFormattingWithArgs() {
        String message = "testNoFormatting";
        Throwable throwable = null;
        Object[] argArray = new Object[]{12, 13};
        LoggingEvent event = new LoggingEvent("", this.logger, Level.INFO, message, throwable, argArray);
        Assert.assertNull((Object)event.formattedMessage);
        Assert.assertEquals((Object)message, (Object)event.getFormattedMessage());
    }

    @Test
    public void testNoFormattingWithoutArgs() {
        String message = "testNoFormatting";
        Throwable throwable = null;
        Object[] argArray = null;
        LoggingEvent event = new LoggingEvent("", this.logger, Level.INFO, message, throwable, argArray);
        Assert.assertNull((Object)event.formattedMessage);
        Assert.assertEquals((Object)message, (Object)event.getFormattedMessage());
    }
}

