/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.jsonTest;

import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import java.util.Objects;

public class ThrowableProxyComparator {
    public static boolean areEqual(IThrowableProxy left, IThrowableProxy right) {
        if (left == right) {
            return true;
        }
        if (left == null) {
            return false;
        }
        if (!left.getClassName().equals(right.getClassName())) {
            return false;
        }
        if (!left.getMessage().equals(right.getMessage())) {
            return false;
        }
        System.out.println("before equalsSTEPArray left.message=" + left.getMessage() + ", right.message=" + right.getMessage());
        StackTraceElementProxy[] leftStepArray = left.getStackTraceElementProxyArray();
        StackTraceElementProxy[] rightStepArray = right.getStackTraceElementProxyArray();
        if (left.getCommonFrames() != right.getCommonFrames()) {
            return false;
        }
        if (!ThrowableProxyComparator.equalsSTEPArray(leftStepArray, rightStepArray, left.getCommonFrames())) {
            return false;
        }
        boolean causeComparaison = ThrowableProxyComparator.areEqual(left.getCause(), right.getCause());
        if (!causeComparaison) {
            return causeComparaison;
        }
        return ThrowableProxyComparator.compareSuppressedThrowables(left, right);
    }

    private static boolean compareSuppressedThrowables(IThrowableProxy left, IThrowableProxy right) {
        IThrowableProxy[] leftSuppressedThrowableArray = left.getSuppressed();
        IThrowableProxy[] rightSuppressedThrowableArray = right.getSuppressed();
        if (leftSuppressedThrowableArray == null && rightSuppressedThrowableArray == null) {
            return true;
        }
        if (leftSuppressedThrowableArray.length == 0 && rightSuppressedThrowableArray == null) {
            return true;
        }
        if (leftSuppressedThrowableArray.length != rightSuppressedThrowableArray.length) {
            System.out.println("suppressed array length discrepancy");
            return false;
        }
        for (int i = 0; i < leftSuppressedThrowableArray.length; ++i) {
            IThrowableProxy leftSuppressed = leftSuppressedThrowableArray[i];
            IThrowableProxy rightSuppressed = rightSuppressedThrowableArray[i];
            boolean suppressedComparison = ThrowableProxyComparator.areEqual(leftSuppressed, rightSuppressed);
            if (suppressedComparison) continue;
            System.out.println("suppressed ITP comparison failed at position " + i);
            return false;
        }
        return true;
    }

    public static boolean equalsSTEPArray(StackTraceElementProxy[] leftStepArray, StackTraceElementProxy[] rightStepArray, int commonFrames) {
        if (leftStepArray == rightStepArray) {
            return true;
        }
        if (leftStepArray == null || rightStepArray == null) {
            return false;
        }
        int length = leftStepArray.length - commonFrames;
        if (rightStepArray.length != length) {
            System.out.println("length discrepancy");
            return false;
        }
        System.out.println("checking ste array elements ");
        for (int i = 0; i < length - commonFrames; ++i) {
            StackTraceElementProxy leftStep = leftStepArray[i];
            StackTraceElementProxy rightStep = rightStepArray[i];
            if (ThrowableProxyComparator.equalsSTEP(leftStep, rightStep)) continue;
            System.out.println("left " + String.valueOf(leftStep));
            System.out.println("right " + String.valueOf(rightStep));
            return false;
        }
        return true;
    }

    public static boolean equalsSTEP(StackTraceElementProxy left, StackTraceElementProxy right) {
        if (left == right) {
            return true;
        }
        if (right == null) {
            return false;
        }
        StackTraceElement l = left.getStackTraceElement();
        StackTraceElement r = right.getStackTraceElement();
        if (!Objects.equals(l.getClassName(), r.getClassName())) {
            return false;
        }
        if (!Objects.equals(l.getMethodName(), r.getMethodName())) {
            return false;
        }
        if (!Objects.equals(l.getFileName(), r.getFileName())) {
            return false;
        }
        return l.getLineNumber() == r.getLineNumber();
    }
}

