/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.util;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.util.ContextInitializer;
import ch.qos.logback.classic.util.MockConfigurator;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.LogbackException;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.testUtil.TrivialStatusListener;
import ch.qos.logback.core.util.Loader;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class ContextInitializerTest {
    static final String PATH_TO_META_INF_CONF_SERVICE = "META-INF/services/ch.qos.logback.classic.spi.Configurator";
    static final String FAKE_META_INF_SERVICES = "FAKE_META_INF_SERVICES_ch_qos_logback_classic_spi_Configurator";
    LoggerContext loggerContext = new LoggerContext();
    Logger root = this.loggerContext.getLogger("ROOT");

    @BeforeEach
    public void setUp() throws Exception {
    }

    @AfterEach
    public void tearDown() throws Exception {
        System.clearProperty("logback.configurationFile");
        System.clearProperty("logback.statusListenerClass");
        MockConfigurator.context = null;
    }

    @Test
    @Disabled
    public void reset() throws JoranException {
        new ContextInitializer(this.loggerContext).autoConfig();
        Appender appender = this.root.getAppender("STDOUT");
        Assertions.assertNotNull((Object)appender);
        Assertions.assertTrue((boolean)(appender instanceof ConsoleAppender));
        this.loggerContext.stop();
        appender = this.root.getAppender("STDOUT");
        Assertions.assertNull((Object)appender);
    }

    @Test
    public void autoConfigFromSystemProperties() throws JoranException {
        this.doAutoConfigFromSystemProperties("src/test/input/autoConfig.xml");
        this.doAutoConfigFromSystemProperties("autoConfigAsResource.xml");
        this.doAutoConfigFromSystemProperties("file://./src/test/input/autoConfig.xml");
    }

    public void doAutoConfigFromSystemProperties(String val) throws JoranException {
        System.setProperty("logback.configurationFile", val);
        new ContextInitializer(this.loggerContext).autoConfig();
        Appender appender = this.root.getAppender("AUTO_BY_SYSTEM_PROPERTY");
        Assertions.assertNotNull((Object)appender);
    }

    @Disabled
    @Test
    public void autoConfigFromServiceLoaderJDK6andAbove() throws Exception {
        Assumptions.assumeTrue((!ContextInitializerTest.isJDK5() ? 1 : 0) != 0);
        ClassLoader mockClassLoader = this.buildMockServiceLoader(this.getClass().getClassLoader());
        Assertions.assertNull((Object)MockConfigurator.context);
        new ContextInitializer(this.loggerContext).autoConfig(mockClassLoader);
        Assertions.assertNotNull((Object)MockConfigurator.context);
        Assertions.assertSame((Object)this.loggerContext, (Object)MockConfigurator.context);
    }

    @Test
    public void autoConfigFromServiceLoaderJDK5() throws Exception {
        Assumptions.assumeTrue((boolean)ContextInitializerTest.isJDK5());
        ClassLoader mockClassLoader = this.buildMockServiceLoader(this.getClass().getClassLoader());
        Assertions.assertNull((Object)MockConfigurator.context);
        new ContextInitializer(this.loggerContext).autoConfig(mockClassLoader);
        Assertions.assertNull((Object)MockConfigurator.context);
    }

    @Test
    public void autoStatusListener() throws JoranException {
        System.setProperty("logback.statusListenerClass", TrivialStatusListener.class.getName());
        List statusListenerList = this.loggerContext.getStatusManager().getCopyOfStatusListenerList();
        Assertions.assertEquals((int)0, (int)statusListenerList.size());
        this.doAutoConfigFromSystemProperties("src/test/input/autoConfig.xml");
        statusListenerList = this.loggerContext.getStatusManager().getCopyOfStatusListenerList();
        Assertions.assertTrue((statusListenerList.size() == 1 ? 1 : 0) != 0, (String)(statusListenerList.size() + " should be 1"));
        TrivialStatusListener tsl = (TrivialStatusListener)statusListenerList.get(0);
        Assertions.assertTrue((tsl.list.size() > 0 ? 1 : 0) != 0, (String)"expecting at least one event in list");
    }

    @Test
    public void autoOnConsoleStatusListener() throws JoranException {
        System.setProperty("logback.statusListenerClass", "SYSOUT");
        List sll = this.loggerContext.getStatusManager().getCopyOfStatusListenerList();
        Assertions.assertEquals((int)0, (int)sll.size());
        this.doAutoConfigFromSystemProperties("src/test/input/autoConfig.xml");
        sll = this.loggerContext.getStatusManager().getCopyOfStatusListenerList();
        Assertions.assertTrue((sll.size() == 1 ? 1 : 0) != 0, (String)(sll.size() + " should be 1"));
    }

    @Test
    public void shouldConfigureFromXmlFile() throws MalformedURLException, JoranException {
        LoggerContext loggerContext = new LoggerContext();
        ContextInitializer initializer = new ContextInitializer(loggerContext);
        Assertions.assertNull((Object)loggerContext.getObject("SAFE_JORAN_CONFIGURATION"));
        URL configurationFileUrl = Loader.getResource((String)"BOO_logback-test.xml", (ClassLoader)Thread.currentThread().getContextClassLoader());
        initializer.configureByResource(configurationFileUrl);
        Assertions.assertNotNull((Object)loggerContext.getObject("SAFE_JORAN_CONFIGURATION"));
    }

    @Test
    public void shouldThrowExceptionIfUnexpectedConfigurationFileExtension() throws JoranException {
        LoggerContext loggerContext = new LoggerContext();
        ContextInitializer initializer = new ContextInitializer(loggerContext);
        URL configurationFileUrl = Loader.getResource((String)"README.txt", (ClassLoader)Thread.currentThread().getContextClassLoader());
        try {
            initializer.configureByResource(configurationFileUrl);
            Assertions.fail((String)"Should throw LogbackException");
        }
        catch (LogbackException logbackException) {
            // empty catch block
        }
    }

    private static boolean isJDK5() {
        String ver = System.getProperty("java.version");
        boolean jdk5 = ver.startsWith("1.5.") || ver.equals("1.5");
        return jdk5;
    }

    private ClassLoader buildMockServiceLoader(ClassLoader realLoader) {
        WrappedClassLoader wrapperClassLoader = new WrappedClassLoader(realLoader){

            public String toString() {
                return "wrapperClassLoader: " + super.toString();
            }

            @Override
            public Enumeration<URL> getResources(String name) throws IOException {
                if (name.endsWith(ContextInitializerTest.PATH_TO_META_INF_CONF_SERVICE)) {
                    System.out.println("Hit on META-INF/services/ch.qos.logback.classic.spi.Configurator");
                    Vector<URL> vs = new Vector<URL>();
                    URL u = super.getResource(ContextInitializerTest.FAKE_META_INF_SERVICES);
                    Assertions.assertNotNull((Object)u);
                    System.out.println("Found url: " + String.valueOf(u));
                    vs.add(u);
                    return vs.elements();
                }
                Enumeration<URL> r = super.getResources(name);
                return r;
            }
        };
        return wrapperClassLoader;
    }

    static class WrappedClassLoader
    extends ClassLoader {
        final ClassLoader delegate;

        public WrappedClassLoader(ClassLoader delegate) {
            this.delegate = delegate;
        }

        @Override
        public Class<?> loadClass(String name) throws ClassNotFoundException {
            return this.delegate.loadClass(name);
        }

        @Override
        public URL getResource(String name) {
            return this.delegate.getResource(name);
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            return this.delegate.getResources(name);
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            return this.delegate.getResourceAsStream(name);
        }

        @Override
        public void setDefaultAssertionStatus(boolean enabled) {
            this.delegate.setDefaultAssertionStatus(enabled);
        }

        @Override
        public void setPackageAssertionStatus(String packageName, boolean enabled) {
            this.delegate.setPackageAssertionStatus(packageName, enabled);
        }

        @Override
        public void setClassAssertionStatus(String className, boolean enabled) {
            this.delegate.setClassAssertionStatus(className, enabled);
        }

        @Override
        public void clearAssertionStatus() {
            this.delegate.clearAssertionStatus();
        }
    }
}

