/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic;

import ch.qos.logback.classic.Foo;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.net.server.HardenedLoggingEventInputStream;
import ch.qos.logback.core.net.HardenedObjectInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.LoggerFactory;

public class LoggerSerializationTest {
    static final String SERIALIZATION_PREFIX = "src/test/input//serialization/";
    org.slf4j.Logger unused = LoggerFactory.getLogger(this.getClass());
    LoggerContext lc;
    Logger logger;
    ByteArrayOutputStream bos;
    ObjectOutputStream oos;
    HardenedLoggingEventInputStream hardenedLoggingEventInputStream;
    List<String> whitelist = new ArrayList<String>();

    @BeforeEach
    public void setUp() throws Exception {
        this.lc = new LoggerContext();
        this.lc.setName("testContext");
        this.logger = this.lc.getLogger(LoggerSerializationTest.class);
        this.bos = new ByteArrayOutputStream();
        this.oos = new ObjectOutputStream(this.bos);
        this.whitelist.add(Foo.class.getName());
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.lc = null;
        this.logger = null;
    }

    @Test
    public void basicSerialization() throws IOException, ClassNotFoundException {
        Foo foo = new Foo(this.logger);
        foo.doFoo();
        Foo fooBack = this.writeAndRead(foo);
        fooBack.doFoo();
    }

    @Test
    public void deepTreeSerialization() throws IOException {
        Logger a = this.lc.getLogger("aaaaaaaa");
        this.lc.getLogger("aaaaaaaa.a");
        this.lc.getLogger("aaaaaaaa.a.a");
        this.lc.getLogger("aaaaaaaa.a.b");
        this.lc.getLogger("aaaaaaaa.a.c");
        this.lc.getLogger("aaaaaaaa.a.d");
        this.lc.getLogger("aaaaaaaa.b");
        this.lc.getLogger("aaaaaaaa.b.a");
        this.lc.getLogger("aaaaaaaa.b.b");
        this.lc.getLogger("aaaaaaaa.b.c");
        this.lc.getLogger("aaaaaaaa.b.d");
        this.lc.getLogger("aaaaaaaa.c");
        this.lc.getLogger("aaaaaaaa.c.a");
        this.lc.getLogger("aaaaaaaa.c.b");
        this.lc.getLogger("aaaaaaaa.c.c");
        this.lc.getLogger("aaaaaaaa.c.d");
        this.lc.getLogger("aaaaaaaa.d");
        this.lc.getLogger("aaaaaaaa.d.a");
        this.lc.getLogger("aaaaaaaa.d.b");
        this.lc.getLogger("aaaaaaaa.d.c");
        this.lc.getLogger("aaaaaaaa.d.d");
        Logger b = this.lc.getLogger("b");
        this.writeObject(this.oos, a);
        this.oos.close();
        int sizeA = this.bos.size();
        this.bos = new ByteArrayOutputStream();
        this.oos = new ObjectOutputStream(this.bos);
        this.writeObject(this.oos, b);
        this.oos.close();
        int sizeB = this.bos.size();
        Assertions.assertTrue((sizeA < 100 ? 1 : 0) != 0, (String)"serialized logger should be less than 100 bytes");
        Assertions.assertTrue((sizeA - sizeB < 10 ? 1 : 0) != 0, (String)("serialized loggers should be nearly the same size a:" + sizeA + ", sizeB:" + sizeB));
    }

    private Foo writeAndRead(Foo foo) throws IOException, ClassNotFoundException {
        this.writeObject(this.oos, foo);
        ByteArrayInputStream bis = new ByteArrayInputStream(this.bos.toByteArray());
        this.hardenedLoggingEventInputStream = new HardenedLoggingEventInputStream((InputStream)bis, this.whitelist);
        Foo fooBack = this.readFooObject((HardenedObjectInputStream)this.hardenedLoggingEventInputStream);
        this.hardenedLoggingEventInputStream.close();
        return fooBack;
    }

    Foo readFooObject(HardenedObjectInputStream inputStream) throws IOException, ClassNotFoundException {
        return (Foo)this.readObject(inputStream);
    }

    private Object readObject(HardenedObjectInputStream inputStream) throws IOException, ClassNotFoundException {
        return inputStream.readObject();
    }

    private void writeObject(ObjectOutputStream oos, Object o) throws IOException {
        oos.writeObject(o);
        oos.flush();
        oos.close();
    }

    @Test
    public void testCompatibilityWith_v1_0_11() throws IOException, ClassNotFoundException {
        FileInputStream fis = new FileInputStream("src/test/input//serialization/logger_v1.0.11.ser");
        HardenedLoggingEventInputStream ois = new HardenedLoggingEventInputStream((InputStream)fis);
        Logger a = (Logger)ois.readObject();
        ois.close();
        Assertions.assertEquals((Object)"a", (Object)a.getName());
    }

    @Test
    public void testCompatibilityWith_v1_0_12() throws IOException, ClassNotFoundException {
        FileInputStream fis = new FileInputStream("src/test/input//serialization/logger_v1.0.12.ser");
        HardenedObjectInputStream ois = new HardenedObjectInputStream((InputStream)fis, new String[]{Logger.class.getName()});
        Logger a = (Logger)ois.readObject();
        ois.close();
        Assertions.assertEquals((Object)"a", (Object)a.getName());
    }
}

