/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.joran;

import ch.qos.logback.classic.AsyncAppender;
import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.jul.JULHelper;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.turbo.DebugUsersTurboFilter;
import ch.qos.logback.classic.turbo.NOPTurboFilter;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.encoder.LayoutWrappingEncoder;
import ch.qos.logback.core.joran.action.ParamAction;
import ch.qos.logback.core.joran.sanity.AppenderWithinAppenderSanityChecker;
import ch.qos.logback.core.joran.spi.ActionException;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.model.processor.ShutdownHookModelHandler;
import ch.qos.logback.core.read.ListAppender;
import ch.qos.logback.core.spi.ScanException;
import ch.qos.logback.core.status.testUtil.StatusChecker;
import ch.qos.logback.core.testUtil.RandomUtil;
import ch.qos.logback.core.testUtil.StringListAppender;
import ch.qos.logback.core.util.CachingDateFormatter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.slf4j.MDC;
import org.slf4j.event.KeyValuePair;

public class JoranConfiguratorTest {
    LoggerContext loggerContext = new LoggerContext();
    Logger logger = this.loggerContext.getLogger(this.getClass().getName());
    Logger root = this.loggerContext.getLogger("ROOT");
    StatusChecker checker = new StatusChecker((Context)this.loggerContext);
    int diff = RandomUtil.getPositiveInt();

    void configure(String file) throws JoranException {
        JoranConfigurator jc = new JoranConfigurator();
        jc.setContext((Context)this.loggerContext);
        this.loggerContext.putProperty("diff", "" + this.diff);
        jc.doConfigure(file);
    }

    @Test
    public void simpleList() throws JoranException {
        this.configure("src/test/input/joran/simpleList.xml");
        Logger logger = this.loggerContext.getLogger(this.getClass().getName());
        Logger root = this.loggerContext.getLogger("ROOT");
        ListAppender listAppender = (ListAppender)root.getAppender("LIST");
        Assertions.assertNotNull((Object)listAppender);
        Assertions.assertEquals((int)0, (int)listAppender.list.size());
        String msg = "hello world";
        logger.debug(msg);
        Assertions.assertEquals((int)1, (int)listAppender.list.size());
        ILoggingEvent le = (ILoggingEvent)listAppender.list.get(0);
        Assertions.assertEquals((Object)msg, (Object)le.getMessage());
    }

    @Test
    public void asyncWithMultipleAppendersInRoot() throws JoranException {
        this.configure("src/test/input/joran/async/logback_1614.xml");
        Logger logger = this.loggerContext.getLogger(this.getClass().getName());
        Logger root = this.loggerContext.getLogger("ROOT");
        AsyncAppender asyncAppender = (AsyncAppender)root.getAppender("ASYNC");
        Assertions.assertNotNull((Object)asyncAppender);
        ConsoleAppender console = (ConsoleAppender)root.getAppender("CONSOLE");
        Assertions.assertNotNull((Object)console);
        Assertions.assertTrue((boolean)console.isStarted());
        String msg = "hello world";
        logger.warn(msg);
    }

    @Test
    public void simpleListWithImports() throws JoranException {
        this.configure("src/test/input/joran/simpleListWithImports.xml");
        Logger logger = this.loggerContext.getLogger(this.getClass().getName());
        Logger root = this.loggerContext.getLogger("ROOT");
        ListAppender listAppender = (ListAppender)root.getAppender("LIST");
        Assertions.assertNotNull((Object)listAppender);
        Assertions.assertEquals((int)0, (int)listAppender.list.size());
        String msg = "hello world";
        logger.debug(msg);
        Assertions.assertEquals((int)1, (int)listAppender.list.size());
        ILoggingEvent le = (ILoggingEvent)listAppender.list.get(0);
        Assertions.assertEquals((Object)msg, (Object)le.getMessage());
    }

    @Test
    public void level() throws JoranException {
        this.configure("src/test/input/joran/simpleLevel.xml");
        ListAppender listAppender = (ListAppender)this.root.getAppender("LIST");
        Assertions.assertEquals((int)0, (int)listAppender.list.size());
        String msg = "hello world";
        this.logger.debug(msg);
        Assertions.assertEquals((int)0, (int)listAppender.list.size());
    }

    @Test
    public void additivity() throws JoranException {
        this.configure("src/test/input/joran/additivity.xml");
        Logger logger = this.loggerContext.getLogger("additivityTest");
        Assertions.assertFalse((boolean)logger.isAdditive());
    }

    @Test
    public void rootLoggerLevelSettingBySystemProperty() throws JoranException {
        String propertyName = "logback.level";
        System.setProperty(propertyName, "INFO");
        this.configure("src/test/input/joran/rootLevelByProperty.xml");
        ListAppender listAppender = (ListAppender)this.root.getAppender("LIST");
        Assertions.assertEquals((int)0, (int)listAppender.list.size());
        String msg = "hello world";
        this.logger.debug(msg);
        Assertions.assertEquals((int)0, (int)listAppender.list.size());
        System.clearProperty(propertyName);
    }

    @Test
    public void loggerLevelSettingBySystemProperty() throws JoranException {
        String propertyName = "logback.level";
        System.setProperty(propertyName, "DEBUG");
        this.configure("src/test/input/joran/loggerLevelByProperty.xml");
        ListAppender listAppender = (ListAppender)this.root.getAppender("LIST");
        Assertions.assertEquals((int)0, (int)listAppender.list.size());
        String msg = "hello world";
        this.logger.debug(msg);
        Assertions.assertEquals((int)1, (int)listAppender.list.size());
        System.clearProperty(propertyName);
    }

    @Test
    public void appenderRefSettingBySystemProperty() throws JoranException {
        String propertyName = "logback.appenderRef";
        System.setProperty("logback.appenderRef", "A");
        this.configure("src/test/input/joran/appenderRefByProperty.xml");
        Logger logger = this.loggerContext.getLogger("ch.qos.logback.classic.joran");
        ListAppender listAppender = (ListAppender)logger.getAppender("A");
        Assertions.assertEquals((int)0, (int)listAppender.list.size());
        String msg = "hello world";
        logger.info("hello world");
        Assertions.assertEquals((int)1, (int)listAppender.list.size());
        System.clearProperty("logback.appenderRef");
    }

    @Test
    public void statusListener() throws JoranException {
        this.configure("src/test/input/joran/statusListener.xml");
        this.checker.assertIsErrorFree();
        this.checker.assertContainsMatch(1, "Please use \"level\" attribute within <logger> or <root> elements instead.");
    }

    @Test
    public void statusListenerWithImports() throws JoranException {
        this.configure("src/test/input/joran/statusListenerWithImports.xml");
        this.checker.assertIsErrorFree();
        this.checker.assertContainsMatch(1, "Please use \"level\" attribute within <logger> or <root> elements instead.");
    }

    @Test
    public void contextRename() throws JoranException {
        this.loggerContext.setName("default");
        this.configure("src/test/input/joran/contextRename.xml");
        Assertions.assertEquals((Object)"wombat", (Object)this.loggerContext.getName());
    }

    @Test
    public void missingConfigurationElement() throws JoranException {
        this.configure("src/test/input/joran/ossfuzz/noConfig.xml");
        String msg1 = "Exception in body\\(\\) method for action \\[" + ParamAction.class.getName() + "\\]";
        this.checker.assertContainsMatch(2, msg1);
        String msg2 = "current model is null. Is <configuration> element missing?";
        this.checker.assertContainsException(ActionException.class, msg2);
    }

    @Test
    public void ignoreUnknownProperty() throws JoranException {
        this.configure("src/test/input/joran/ossfuzz/unknownProperty.xml");
        String msg = "Ignoring unknown property \\[a\\] in \\[ch.qos.logback.classic.LoggerContext\\]";
        this.checker.assertContainsMatch(1, msg);
    }

    @Test
    public void complexCollectionWihhNoKnownClass() throws JoranException {
        this.configure("src/test/input/joran/ossfuzz/nestedComplexWithNoKnownClass.xml");
        String msg = "Could not find an appropriate class for property \\[listener\\]";
        this.checker.assertContainsMatch(2, msg);
    }

    @Test
    public void turboFilter() throws JoranException {
        this.configure("src/test/input/joran/turbo.xml");
        TurboFilter filter = (TurboFilter)this.loggerContext.getTurboFilterList().get(0);
        Assertions.assertTrue((boolean)(filter instanceof NOPTurboFilter));
    }

    @Test
    public void testTurboFilterWithStringList() throws JoranException {
        this.configure("src/test/input/joran/turbo2.xml");
        TurboFilter filter = (TurboFilter)this.loggerContext.getTurboFilterList().get(0);
        Assertions.assertTrue((boolean)(filter instanceof DebugUsersTurboFilter));
        DebugUsersTurboFilter dutf = (DebugUsersTurboFilter)filter;
        Assertions.assertEquals((int)2, (int)dutf.getUsers().size());
    }

    @Test
    public void testLevelFilter() throws JoranException {
        this.configure("src/test/input/joran/levelFilter.xml");
        this.logger.warn("hello");
        this.logger.error("to be ignored");
        ListAppender listAppender = (ListAppender)this.root.getAppender("LIST");
        Assertions.assertNotNull((Object)listAppender);
        Assertions.assertEquals((int)1, (int)listAppender.list.size());
        ILoggingEvent back = (ILoggingEvent)listAppender.list.get(0);
        Assertions.assertEquals((Object)Level.WARN, (Object)back.getLevel());
        Assertions.assertEquals((Object)"hello", (Object)back.getMessage());
    }

    @Test
    public void testTurboDynamicThreshold() throws JoranException {
        this.configure("src/test/input/joran/turboDynamicThreshold.xml");
        ListAppender listAppender = (ListAppender)this.root.getAppender("LIST");
        Assertions.assertEquals((int)0, (int)listAppender.list.size());
        MDC.put((String)"userId", (String)"user1");
        this.logger.debug("hello user1");
        MDC.put((String)"userId", (String)"user2");
        this.logger.debug("hello user2");
        Assertions.assertEquals((int)1, (int)listAppender.list.size());
        ILoggingEvent le = (ILoggingEvent)listAppender.list.get(0);
        Assertions.assertEquals((Object)"hello user2", (Object)le.getMessage());
    }

    @Test
    public void testTurboDynamicThreshold2() throws JoranException {
        this.configure("src/test/input/joran/turboDynamicThreshold2.xml");
        ListAppender listAppender = (ListAppender)this.root.getAppender("LIST");
        Assertions.assertEquals((int)0, (int)listAppender.list.size());
        MDC.put((String)"userId", (String)"user1");
        this.logger.debug("hello user1");
        MDC.put((String)"userId", (String)"user2");
        this.logger.debug("hello user2");
        MDC.put((String)"userId", (String)"user3");
        this.logger.debug("hello user3");
        Assertions.assertEquals((int)2, (int)listAppender.list.size());
        ILoggingEvent le = (ILoggingEvent)listAppender.list.get(0);
        Assertions.assertEquals((Object)"hello user1", (Object)le.getMessage());
        le = (ILoggingEvent)listAppender.list.get(1);
        Assertions.assertEquals((Object)"hello user2", (Object)le.getMessage());
    }

    @Test
    public void timestamp() throws JoranException, IOException, InterruptedException {
        String configFileAsStr = "src/test/input/joran/timestamp-context.xml";
        this.configure(configFileAsStr);
        String r = this.loggerContext.getProperty("testTimestamp");
        Assertions.assertNotNull((Object)r);
        CachingDateFormatter sdf = new CachingDateFormatter("yyyy-MM");
        String expected = sdf.format(System.currentTimeMillis());
        Assertions.assertEquals((Object)expected, (Object)r, (String)("expected \"" + expected + "\" but got " + r));
    }

    @Test
    public void timestampLocal() throws JoranException, IOException, InterruptedException {
        String sysProp = "ch.qos.logback.classic.joran.JoranConfiguratorTest.timestampLocal";
        System.setProperty(sysProp, "");
        String configFileAsStr = "src/test/input/joran/timestamp-local.xml";
        this.configure(configFileAsStr);
        String r = this.loggerContext.getProperty("testTimestamp");
        Assertions.assertNull((Object)r);
        String expected = "today is " + new SimpleDateFormat("yyyy-MM").format(new Date());
        String sysPropValue = System.getProperty(sysProp);
        Assertions.assertEquals((Object)expected, (Object)sysPropValue);
    }

    @Test
    public void encoderCharset() throws JoranException, IOException, InterruptedException {
        String configFileAsStr = "src/test/input/joran/encoderCharset.xml";
        this.configure(configFileAsStr);
        ConsoleAppender consoleAppender = (ConsoleAppender)this.root.getAppender("CONSOLE");
        Assertions.assertNotNull((Object)consoleAppender);
        LayoutWrappingEncoder encoder = (LayoutWrappingEncoder)consoleAppender.getEncoder();
        Assertions.assertEquals((Object)"UTF-8", (Object)encoder.getCharset().displayName());
        this.checker.assertIsErrorFree();
    }

    void verifyJULLevel(String loggerName, Level expectedLevel) {
        java.util.logging.Logger julLogger = JULHelper.asJULLogger((String)loggerName);
        java.util.logging.Level julLevel = julLogger.getLevel();
        if (expectedLevel == null) {
            Assertions.assertNull((Object)julLevel);
        } else {
            Assertions.assertEquals((Object)JULHelper.asJULLevel((Level)expectedLevel), (Object)julLevel);
        }
    }

    @Test
    public void levelChangePropagator0() throws JoranException, IOException, InterruptedException {
        String loggerName = "changePropagator0" + this.diff;
        java.util.logging.Logger.getLogger(loggerName).setLevel(java.util.logging.Level.INFO);
        String configFileAsStr = "src/test/input/joran//jul/levelChangePropagator0.xml";
        this.configure(configFileAsStr);
        this.checker.assertIsErrorFree();
        this.verifyJULLevel(loggerName, null);
        this.verifyJULLevel("a.b.c." + this.diff, Level.WARN);
        this.verifyJULLevel("ROOT", Level.TRACE);
    }

    @Test
    public void levelChangePropagator1() throws JoranException, IOException, InterruptedException {
        String loggerName = "changePropagator1" + this.diff;
        java.util.logging.Logger logger1 = java.util.logging.Logger.getLogger(loggerName);
        logger1.setLevel(java.util.logging.Level.INFO);
        this.verifyJULLevel(loggerName, Level.INFO);
        String configFileAsStr = "src/test/input/joran//jul/levelChangePropagator1.xml";
        this.configure(configFileAsStr);
        this.checker.assertIsErrorFree();
        this.verifyJULLevel(loggerName, Level.INFO);
        this.verifyJULLevel("a.b.c." + this.diff, Level.WARN);
        this.verifyJULLevel("ROOT", Level.TRACE);
    }

    @Disabled
    @Test
    public void onConsoleRetro() throws JoranException, IOException, InterruptedException {
        String configFileAsStr = "src/test/input/joran//onConsoleRetro.xml";
        this.configure(configFileAsStr);
        Thread.sleep(400L);
        this.loggerContext.reset();
        this.configure(configFileAsStr);
    }

    @Test
    public void unreferencedAppenderShouldNotTriggerUnknownPropertyMessages() throws JoranException {
        String configFileAsStr = "src/test/input/joran/issues//logback1572.xml";
        this.configure(configFileAsStr);
        this.checker.assertContainsMatch(1, "Appender named \\[EMAIL\\] not referenced. Skipping further processing.");
        this.checker.assertNoMatch("Ignoring unknown property \\[evaluator\\]");
    }

    @Test
    public void LOGBACK_111() throws JoranException {
        String configFileAsStr = "src/test/input/joran/issues/lbcore193.xml";
        this.configure(configFileAsStr);
        this.checker.assertContainsException(ScanException.class);
        this.checker.assertContainsMatch(2, "Expecting RIGHT_PARENTHESIS token but got null");
        this.checker.assertContainsMatch(2, "See also http://logback.qos.ch/codes.html#missingRightParenthesis");
    }

    @Test
    public void properties() throws JoranException {
        String configFileAsStr = "src/test/input/joran/properties.xml";
        Assertions.assertNull((Object)System.getProperty("sys"));
        this.configure(configFileAsStr);
        Assertions.assertNotNull((Object)this.loggerContext.getProperty("HOSTNAME"));
        Assertions.assertNull((Object)this.loggerContext.getProperty("transientKey1"));
        Assertions.assertNull((Object)this.loggerContext.getProperty("transientKey2"));
        Assertions.assertEquals((Object)"node0", (Object)this.loggerContext.getProperty("nodeId"));
        Assertions.assertEquals((Object)"tem", (Object)System.getProperty("sys"));
        Assertions.assertNotNull((Object)this.loggerContext.getProperty("path"));
        this.checker.assertIsErrorFree();
    }

    @Test
    public void hostnameProperty() throws JoranException {
        String configFileAsStr = "src/test/input/joran/hostnameProperty.xml";
        this.configure(configFileAsStr);
        Assertions.assertEquals((Object)"A", (Object)this.loggerContext.getProperty("HOSTNAME"));
    }

    @Test
    public void sysProps() throws JoranException {
        System.setProperty("k.lbcore254", "src/test/input/joran/issues/lbcore254");
        JoranConfigurator configurator = new JoranConfigurator();
        configurator.setContext((Context)this.loggerContext);
        configurator.doConfigure("src/test/input/joran/issues/lbcore254.xml");
        this.checker.assertIsErrorFree();
    }

    @Test
    public void propsWithMissingRightCurlyBrace() throws JoranException {
        System.setProperty("abc", "not important");
        JoranConfigurator configurator = new JoranConfigurator();
        configurator.setContext((Context)this.loggerContext);
        configurator.doConfigure("src/test/input/joran/propsMissingRightCurlyBrace.xml");
        this.checker.assertContainsMatch(2, "Problem while parsing");
    }

    @Test
    public void packageDataDisabledByConfigAttribute() throws JoranException {
        String configFileAsStr = "src/test/input/joran/packagingDataDisabled.xml";
        this.configure(configFileAsStr);
        Assertions.assertFalse((boolean)this.loggerContext.isPackagingDataEnabled());
    }

    @Test
    public void packageDataEnabledByConfigAttribute() throws JoranException {
        String configFileAsStr = "src/test/input/joran/packagingDataEnabled.xml";
        this.configure(configFileAsStr);
        Assertions.assertTrue((boolean)this.loggerContext.isPackagingDataEnabled());
    }

    @Test
    public void valueOfConvention() throws JoranException {
        String configFileAsStr = "src/test/input/joran/valueOfConvention.xml";
        this.configure(configFileAsStr);
        this.checker.assertIsWarningOrErrorFree();
    }

    @Test
    public void shutdownHookTest() throws JoranException {
        String configFileAsStr = "src/test/input/joran/issues/logback_1162.xml";
        this.loggerContext.putProperty("output_dir", "target/test-output/logback_issue_1162/");
        this.configure(configFileAsStr);
        Thread thread = (Thread)this.loggerContext.getObject("SHUTDOWN_HOOK");
        Assertions.assertNotNull((Object)thread);
    }

    @Test
    public void nestedAppendersDisallowed() throws JoranException {
        String configFileAsStr = "src/test/input/joran/issues/logback_1674.xml";
        this.configure(configFileAsStr);
        this.checker.assertContainsMatch(1, AppenderWithinAppenderSanityChecker.NESTED_APPENDERS_WARNING);
        this.checker.assertContainsMatch(1, "Appender at line ");
    }

    @Test
    public void shutdownHookWithDelayParameter() throws JoranException {
        String configFileAsStr = "src/test/input/joran/issues/logback_1672.xml";
        this.configure(configFileAsStr);
        Thread thread = (Thread)this.loggerContext.getObject("SHUTDOWN_HOOK");
        Assertions.assertNotNull((Object)thread);
        this.checker.assertNoMatch("Ignoring unknown property");
    }

    @Test
    public void migrateShutdownHookClassName() throws JoranException {
        String configFileAsStr = "src/test/input/joran/issues/logback_1678_shutdown.xml";
        this.configure(configFileAsStr);
        Thread thread = (Thread)this.loggerContext.getObject("SHUTDOWN_HOOK");
        Assertions.assertNotNull((Object)thread);
        this.checker.assertContainsMatch(ShutdownHookModelHandler.RENAME_WARNING);
    }

    @Test
    public void appenderRefBeforeAppenderTest() throws JoranException {
        String configFileAsStr = "src/test/input/joran/appenderRefBeforeAppender.xml";
        this.configure(configFileAsStr);
        Logger logger = this.loggerContext.getLogger(this.getClass().getName());
        Logger root = this.loggerContext.getLogger("ROOT");
        ListAppender listAppender = (ListAppender)root.getAppender("LIST");
        Assertions.assertNotNull((Object)listAppender);
        Assertions.assertEquals((int)0, (int)listAppender.list.size());
        String msg = "hello world";
        logger.debug(msg);
        Assertions.assertEquals((int)1, (int)listAppender.list.size());
        ILoggingEvent le = (ILoggingEvent)listAppender.list.get(0);
        Assertions.assertEquals((Object)msg, (Object)le.getMessage());
        this.checker.assertIsErrorFree();
    }

    @Test
    public void unreferencedAppendersShouldBeSkipped() throws JoranException {
        this.configure("src/test/input/joran/unreferencedAppender1.xml");
        ListAppender listAppenderA = (ListAppender)this.root.getAppender("A");
        Assertions.assertNotNull((Object)listAppenderA);
        this.checker.assertContainsMatch(1, "Appender named \\[B\\] not referenced. Skipping further processing.");
    }

    @Test
    public void asynAppenderListFirst() throws JoranException {
        this.configure("src/test/input/joran/asyncAppender_list_first.xml");
        AsyncAppender asyncAppender = (AsyncAppender)this.root.getAppender("ASYNC");
        Assertions.assertNotNull((Object)asyncAppender);
        Assertions.assertTrue((boolean)asyncAppender.isStarted());
    }

    @Test
    public void asynAppenderListAfter() throws JoranException {
        this.configure("src/test/input/joran/asyncAppender_list_after.xml");
        AsyncAppender asyncAppender = (AsyncAppender)this.root.getAppender("ASYNC");
        Assertions.assertNotNull((Object)asyncAppender);
        Assertions.assertTrue((boolean)asyncAppender.isStarted());
    }

    @Test
    public void missingPropertyErrorHandling() throws JoranException {
        this.configure("src/test/input/joran/missingProperty.xml");
        ListAppender listAppender = (ListAppender)this.root.getAppender("LIST");
        Assertions.assertNotNull((Object)listAppender);
        Assertions.assertTrue((boolean)listAppender.isStarted());
        this.checker.assertContainsMatch(1, "Ignoring unknown property \\[inexistent\\] in \\[ch.qos.logback.core.read.ListAppender\\]");
    }

    @Test
    public void sequenceNumberGenerator() throws JoranException {
        this.configure("src/test/input/joran/sequenceNumberGenerator.xml");
        ListAppender listAppender = (ListAppender)this.root.getAppender("LIST");
        Assertions.assertNotNull((Object)listAppender);
        this.logger.atDebug().setMessage("hello").log();
        this.logger.atDebug().setMessage("world").log();
        ILoggingEvent le0 = (ILoggingEvent)listAppender.list.get(0);
        ILoggingEvent le1 = (ILoggingEvent)listAppender.list.get(1);
        long se0 = le0.getSequenceNumber();
        long se1 = le1.getSequenceNumber();
        Assertions.assertEquals((long)1L, (long)(se1 - se0));
    }

    @Test
    public void sequenceNumberGenerator_missingClass() throws JoranException {
        this.configure("src/test/input/joran/sequenceNumberGenerator-missingClass.xml");
        ListAppender listAppender = (ListAppender)this.root.getAppender("LIST");
        Assertions.assertNotNull((Object)listAppender);
        this.checker.assertContainsMatch(2, "Missing attribute \\[class\\] in element \\[sequenceNumberGenerator\\]");
    }

    @Test
    public void kvp() throws JoranException {
        this.configure("src/test/input/joran/pattern/kvp.xml");
        String msg = "hello kvp";
        KeyValuePair kvp1 = new KeyValuePair("k" + this.diff, (Object)("v" + this.diff));
        KeyValuePair kvp2 = new KeyValuePair("k" + (this.diff + 1), (Object)("v" + (this.diff + 1)));
        KeyValuePair kvpNullKey = new KeyValuePair(null, (Object)("v" + (this.diff + 2)));
        KeyValuePair kvpNullValue = new KeyValuePair("k" + (this.diff + 3), null);
        this.logger.atDebug().addKeyValue(kvp1.key, kvp1.value).log(msg);
        this.logger.atDebug().addKeyValue(kvp2.key, kvp2.value).log(msg);
        this.logger.atDebug().addKeyValue(kvpNullKey.key, kvpNullKey.value).log(msg);
        this.logger.atDebug().addKeyValue(kvpNullValue.key, kvpNullValue.value).log(msg);
        StringListAppender slAppender = (StringListAppender)this.loggerContext.getLogger("root").getAppender("LIST");
        Assertions.assertNotNull((Object)slAppender);
        Assertions.assertEquals((int)4, (int)slAppender.strList.size());
        Assertions.assertTrue((boolean)((String)slAppender.strList.get(0)).contains(kvp1.key + "=\"" + String.valueOf(kvp1.value) + "\" " + msg));
        Assertions.assertTrue((boolean)((String)slAppender.strList.get(1)).contains(kvp2.key + "=\"" + String.valueOf(kvp2.value) + "\" " + msg));
        Assertions.assertTrue((boolean)((String)slAppender.strList.get(2)).contains("null=\"" + String.valueOf(kvpNullKey.value) + "\" " + msg));
        Assertions.assertTrue((boolean)((String)slAppender.strList.get(3)).contains(kvpNullValue.key + "=\"null\" " + msg));
    }

    @Test
    public void ossFuzz_46697() throws JoranException {
        this.configure("src/test/input/joran/ossfuzz/fuzz-46697.xml");
        this.checker.assertContainsMatch(2, "Could not find valid configuration instructions. Exiting.");
    }

    @Test
    public void ossFuzz_47093() throws JoranException {
        this.configure("src/test/input/joran/ossfuzz/fuzz-47093.xml");
        Assertions.assertEquals((Object)"a\\t", (Object)this.loggerContext.getProperty("fuzz-47093-a"));
        Assertions.assertEquals((Object)"a\\\\", (Object)this.loggerContext.getProperty("fuzz-47093-b"));
    }

    @Test
    public void ossFuzz_41117() throws JoranException {
        this.configure("src/test/input/joran/ossfuzz/fuzz-47117.xml");
        this.checker.assertContainsMatch(2, "The level for the ROOT logger cannot be set to NULL or INHERITED. Ignoring.");
        this.checker.assertErrorCount(2);
    }

    @Test
    public void ossFuzz_41117_bis() throws JoranException {
        this.configure("src/test/input/joran/ossfuzz/fuzz-47117-bis.xml");
        this.checker.assertContainsMatch(2, "The level for the ROOT logger cannot be set to NULL or INHERITED. Ignoring.");
    }

    @Test
    public void ossFuzz_41117_bis2() throws JoranException {
        this.configure("src/test/input/joran/ossfuzz/fuzz-47117-bis2.xml");
        this.checker.assertContainsMatch(2, "The level for the ROOT logger cannot be set to NULL or INHERITED. Ignoring.");
    }

    @Test
    public void ossFuzz_47293() throws JoranException {
        this.configure("src/test/input/joran/ossfuzz/fuzz-47293.xml");
        this.checker.assertContainsMatch(2, "Unexpected empty model stack. Have you omitted the <if> part?");
    }
}

