/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.util;

import ch.qos.logback.classic.util.LoggerNameUtil;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LoggerNameUtilTest {
    @Test
    public void smoke0() {
        ArrayList<String> witnessList = new ArrayList<String>();
        witnessList.add("a");
        witnessList.add("b");
        witnessList.add("c");
        List partList = LoggerNameUtil.computeNameParts((String)"a.b.c");
        Assertions.assertEquals(witnessList, (Object)partList);
    }

    @Test
    public void smoke1() {
        ArrayList<String> witnessList = new ArrayList<String>();
        witnessList.add("com");
        witnessList.add("foo");
        witnessList.add("Bar");
        List partList = LoggerNameUtil.computeNameParts((String)"com.foo.Bar");
        Assertions.assertEquals(witnessList, (Object)partList);
    }

    @Test
    public void emptyStringShouldReturnAListContainingOneEmptyString() {
        ArrayList<String> witnessList = new ArrayList<String>();
        witnessList.add("");
        List partList = LoggerNameUtil.computeNameParts((String)"");
        Assertions.assertEquals(witnessList, (Object)partList);
    }

    @Test
    public void dotAtLastPositionShouldReturnAListWithAnEmptyStringAsLastElement() {
        ArrayList<String> witnessList = new ArrayList<String>();
        witnessList.add("com");
        witnessList.add("foo");
        witnessList.add("");
        List partList = LoggerNameUtil.computeNameParts((String)"com.foo.");
        Assertions.assertEquals(witnessList, (Object)partList);
    }

    @Test
    public void supportNestedClasses() {
        ArrayList<String> witnessList = new ArrayList<String>();
        witnessList.add("com");
        witnessList.add("foo");
        witnessList.add("Bar");
        witnessList.add("Nested");
        List partList = LoggerNameUtil.computeNameParts((String)"com.foo.Bar$Nested");
        Assertions.assertEquals(witnessList, (Object)partList);
    }

    @Test
    public void supportNestedClassesWithNestedDot() {
        ArrayList<String> witnessList = new ArrayList<String>();
        witnessList.add("com");
        witnessList.add("foo");
        witnessList.add("Bar");
        witnessList.add("Nested");
        witnessList.add("dot");
        List partList = LoggerNameUtil.computeNameParts((String)"com.foo.Bar$Nested.dot");
        Assertions.assertEquals(witnessList, (Object)partList);
    }

    @Test
    public void supportNestedClassesAtBeginning() {
        ArrayList<String> witnessList = new ArrayList<String>();
        witnessList.add("foo");
        witnessList.add("Nested");
        witnessList.add("bar");
        List partList = LoggerNameUtil.computeNameParts((String)"foo$Nested.bar");
        Assertions.assertEquals(witnessList, (Object)partList);
    }
}

