/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.issue.lbclassic36;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.junit.jupiter.api.Test;

public class DateFormatOriginal_tzest {
    public static final String ISO8601_PATTERN = "yyyy-MM-dd HH:mm:ss,SSS";
    static final long NANOS_IN_ONE_SEC = 1000000000L;

    @Test
    public void testSynchronized() throws Exception {
        SynchronizedDateFormatter formatter = new SynchronizedDateFormatter();
        int threads = 10;
        int iterations = 10000;
        Thread[] formatThreads = new Thread[threads];
        Date date = new Date();
        for (int i = 0; i < threads; ++i) {
            formatThreads[i] = new DateFormatThread(formatter, date, iterations);
        }
        long start = System.nanoTime();
        for (Thread thread : formatThreads) {
            thread.start();
        }
        for (Thread thread : formatThreads) {
            thread.join();
        }
        long end = System.nanoTime();
        double actual = (double)(end - start) / 1.0E9;
        System.out.printf("Synchronized DateFormat: %,.4f seconds\n", actual);
    }

    @Test
    public void testUnSynchronized() throws Exception {
        UnsynchronizedDateFormatter formatter = new UnsynchronizedDateFormatter();
        int threads = 10;
        int iterations = 10000;
        Thread[] formatThreads = new Thread[threads];
        Date date = new Date();
        for (int i = 0; i < threads; ++i) {
            formatThreads[i] = new DateFormatThread(formatter, date, iterations);
        }
        long start = System.nanoTime();
        for (Thread thread : formatThreads) {
            thread.start();
        }
        for (Thread thread : formatThreads) {
            thread.join();
        }
        long end = System.nanoTime();
        double actual = (double)(end - start) / 1.0E9;
        System.out.printf("Unsynchronized DateFormat: %,.4f seconds\n", actual);
    }

    @Test
    public void testThreadLocal() throws Exception {
        ThreadLocalDateFormatter formatter = new ThreadLocalDateFormatter();
        int threads = 10;
        int iterations = 10000;
        Thread[] formatThreads = new Thread[threads];
        Date date = new Date();
        for (int i = 0; i < threads; ++i) {
            formatThreads[i] = new DateFormatThread(formatter, date, iterations);
        }
        long start = System.nanoTime();
        for (Thread thread : formatThreads) {
            thread.start();
        }
        for (Thread thread : formatThreads) {
            thread.join();
        }
        long end = System.nanoTime();
        double actual = (double)(end - start) / 1.0E9;
        System.out.printf("ThreadLocal DateFormat: %,.4f seconds\n", actual);
    }

    public static class SynchronizedDateFormatter
    implements Formatter {
        SimpleDateFormat simpleFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");

        @Override
        public synchronized String format(Date date) {
            return this.simpleFormat.format(date);
        }
    }

    public static class DateFormatThread
    extends Thread {
        Formatter formatter;
        Date date;
        long iterCount;

        public DateFormatThread(Formatter f, Date date, long iterations) {
            this.formatter = f;
            this.date = date;
            this.iterCount = iterations;
        }

        @Override
        public void run() {
            int i = 0;
            while ((long)i < this.iterCount) {
                this.formatter.format(this.date);
                ++i;
            }
        }
    }

    public static interface Formatter {
        public String format(Date var1);
    }

    public static class UnsynchronizedDateFormatter
    implements Formatter {
        @Override
        public synchronized String format(Date date) {
            return new SimpleDateFormat(DateFormatOriginal_tzest.ISO8601_PATTERN).format(date);
        }
    }

    public static class ThreadLocalDateFormatter
    implements Formatter {
        ThreadLocal<SimpleDateFormat> formatter = new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected synchronized SimpleDateFormat initialValue() {
                return new SimpleDateFormat(DateFormatOriginal_tzest.ISO8601_PATTERN);
            }
        };

        @Override
        public String format(Date date) {
            return this.formatter.get().format(date);
        }
    }
}

