/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.joran;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.issue.lbclassic135.LoggingRunnable;
import ch.qos.logback.classic.joran.ChangeDetectedListener;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.joran.ReconfigurationDoneListener;
import ch.qos.logback.classic.joran.ReconfigurationTaskRegisteredConfigEventListener;
import ch.qos.logback.classic.joran.ReconfigureOnChangeTask;
import ch.qos.logback.classic.joran.ReconfigureOnChangeTaskHarness;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.contention.RunnableWithCounterAndDone;
import ch.qos.logback.core.joran.spi.ConfigurationWatchList;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.joran.util.ConfigurationWatchListUtil;
import ch.qos.logback.core.spi.ConfigurationEvent;
import ch.qos.logback.core.spi.ConfigurationEventListener;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.WarnStatus;
import ch.qos.logback.core.status.testUtil.StatusChecker;
import ch.qos.logback.core.testUtil.FileTestUtil;
import ch.qos.logback.core.testUtil.RandomUtil;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class ReconfigureOnChangeTaskTest {
    static final int THREAD_COUNT = 5;
    static final int TIMEOUT = 4;
    static final int TIMEOUT_LONG = 10;
    int diff = RandomUtil.getPositiveInt();
    static final String SCAN1_FILE_AS_STR = "src/test/input/joran/roct/scan 1.xml";
    static final String SCAN_LOGBACK_474_FILE_AS_STR = "src/test/input/joran/roct/scan_logback_474.xml";
    static final String INCLUSION_SCAN_TOPLEVEL0_AS_STR = "src/test/input/joran/roct/inclusion/topLevel0.xml";
    static final String INCLUSION_SCAN_TOP_BY_RESOURCE_AS_STR = "src/test/input/joran/roct/inclusion/topByResource.xml";
    static final String INCLUSION_SCAN_INNER0_AS_STR = "src/test/input/joran/roct/inclusion/inner0.xml";
    static final String INCLUSION_SCAN_INNER1_AS_STR = "target/test-classes/asResource/inner1.xml";
    private static final String SCAN_PERIOD_DEFAULT_FILE_AS_STR = "src/test/input/joran/roct/scan_period_default.xml";
    LoggerContext loggerContext = new LoggerContext();
    Logger logger = this.loggerContext.getLogger(this.getClass());
    StatusChecker statusChecker = new StatusChecker((Context)this.loggerContext);

    @BeforeAll
    public static void classSetup() {
        FileTestUtil.makeTestOutputDir();
    }

    @BeforeEach
    public void before() {
        this.loggerContext.setName("ROCTTest-context" + this.diff);
    }

    void configure(File file) throws JoranException {
        JoranConfigurator jc = new JoranConfigurator();
        jc.setContext((Context)this.loggerContext);
        jc.doConfigure(file);
    }

    void configure(InputStream is) throws JoranException {
        JoranConfigurator jc = new JoranConfigurator();
        jc.setContext((Context)this.loggerContext);
        jc.doConfigure(is);
    }

    @Test
    @Timeout(value=4L, unit=TimeUnit.SECONDS)
    public void checkBasicLifecyle() throws JoranException, IOException, InterruptedException {
        File file = new File(SCAN1_FILE_AS_STR);
        this.configure(file);
        List<File> fileList = this.getConfigurationWatchList(this.loggerContext);
        this.assertThatListContainsFile(fileList, file);
        this.checkThatTaskHasRan();
        this.checkThatTaskCanBeStopped();
    }

    private void checkThatTaskCanBeStopped() {
        ScheduledFuture future = (ScheduledFuture)this.loggerContext.getCopyOfScheduledFutures().get(0);
        this.loggerContext.stop();
        Assertions.assertTrue((boolean)future.isCancelled());
    }

    private void checkThatTaskHasRan() throws InterruptedException {
        this.waitForReconfigureOnChangeTaskToRun();
    }

    List<File> getConfigurationWatchList(LoggerContext lc) {
        ConfigurationWatchList configurationWatchList = ConfigurationWatchListUtil.getConfigurationWatchList((Context)lc);
        return configurationWatchList.getCopyOfFileWatchList();
    }

    @Test
    @Timeout(value=4L, unit=TimeUnit.SECONDS)
    public void scanWithFileInclusion() throws JoranException, IOException, InterruptedException {
        File topLevelFile = new File(INCLUSION_SCAN_TOPLEVEL0_AS_STR);
        File innerFile = new File(INCLUSION_SCAN_INNER0_AS_STR);
        this.configure(topLevelFile);
        List<File> fileList = this.getConfigurationWatchList(this.loggerContext);
        this.assertThatListContainsFile(fileList, topLevelFile);
        this.assertThatListContainsFile(fileList, innerFile);
        this.checkThatTaskHasRan();
        this.checkThatTaskCanBeStopped();
    }

    @Test
    @Timeout(value=4L, unit=TimeUnit.SECONDS)
    public void scanWithResourceInclusion() throws JoranException, IOException, InterruptedException {
        File topLevelFile = new File(INCLUSION_SCAN_TOP_BY_RESOURCE_AS_STR);
        File innerFile = new File(INCLUSION_SCAN_INNER1_AS_STR);
        this.configure(topLevelFile);
        List<File> fileList = this.getConfigurationWatchList(this.loggerContext);
        this.assertThatListContainsFile(fileList, topLevelFile);
        this.assertThatListContainsFile(fileList, innerFile);
    }

    @Test
    @Timeout(value=4L, unit=TimeUnit.SECONDS)
    public void reconfigurationIsNotPossibleInTheAbsenceOfATopFile() throws IOException, JoranException, InterruptedException {
        ReconfigurationTaskRegisteredConfigEventListener listener = new ReconfigurationTaskRegisteredConfigEventListener();
        this.loggerContext.addConfigurationEventListener((ConfigurationEventListener)listener);
        String configurationStr = "<configuration scan=\"true\" scanPeriod=\"50 millisecond\"><include resource=\"asResource/inner1.xml\"/></configuration>";
        this.configure(new ByteArrayInputStream(configurationStr.getBytes("UTF-8")));
        ConfigurationWatchList configurationWatchList = ConfigurationWatchListUtil.getConfigurationWatchList((Context)this.loggerContext);
        Assertions.assertNull((Object)configurationWatchList);
        this.statusChecker.containsMatch(1, "Due to missing top level");
        Assertions.assertFalse((boolean)listener.changeDetectorRegisteredEventOccurred);
        Assertions.assertEquals((int)0, (int)this.loggerContext.getCopyOfScheduledFutures().size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=4L, unit=TimeUnit.SECONDS)
    public void fallbackToSafe_FollowedByRecovery() throws IOException, JoranException, InterruptedException {
        String path = "target/test-output/reconfigureOnChangeConfig_fallbackToSafe-" + this.diff + ".xml";
        File topLevelFile = new File(path);
        this.writeToFile(topLevelFile, "<configuration scan=\"true\" scanPeriod=\"25 millisecond\"><root level=\"ERROR\"/></configuration> ");
        this.addResetResistantOnConsoleStatusListener();
        this.configure(topLevelFile);
        long afterFirstConfiguration = System.currentTimeMillis();
        CountDownLatch changeDetectedLatch = this.registerChangeDetectedListener();
        CountDownLatch configurationDoneLatch = this.registerNewReconfigurationDoneListener();
        String badXML = "<configuration scan=\"true\" scanPeriod=\"5 millisecond\">\n  <root></configuration>";
        this.writeToFile(topLevelFile, badXML);
        changeDetectedLatch.await();
        configurationDoneLatch.await();
        this.addInfo("Woke from configurationDoneLatch.await()", this);
        this.statusChecker.assertContainsMatch(2, "XML_PARSING");
        this.statusChecker.assertContainsMatch(1, "Given previous errors, falling back to previously registered safe configuration.");
        this.statusChecker.assertContainsMatch(0, "Re-registering previous fallback configuration once more as a fallback configuration point");
        this.loggerContext.getStatusManager().clear();
        this.addInfo("after loggerContext.getStatusManager().clear() ", this);
        CountDownLatch secondConfigEndedLatch = this.registerNewReconfigurationDoneListener();
        this.writeToFile(topLevelFile, "<configuration scan=\"true\" scanPeriod=\"5 millisecond\"><root level=\"ERROR\"/></configuration> ");
        secondConfigEndedLatch.await();
        try {
            this.statusChecker.assertIsErrorFree();
            this.statusChecker.containsMatch("Detected change in configuration files.");
        }
        finally {
            StatusPrinter.print((Context)this.loggerContext);
        }
    }

    private void addResetResistantOnConsoleStatusListener() {
    }

    @Test
    @Timeout(value=10L, unit=TimeUnit.SECONDS)
    public void fallbackToSafeWithIncludedFile_FollowedByRecovery() throws IOException, JoranException, InterruptedException, ExecutionException {
        String topLevelFileAsStr = "target/test-output/reconfigureOnChangeConfig_top-" + this.diff + ".xml";
        String innerFileAsStr = "target/test-output/reconfigureOnChangeConfig_inner-" + this.diff + ".xml";
        File topLevelFile = new File(topLevelFileAsStr);
        this.writeToFile(topLevelFile, "<configuration xdebug=\"true\" scan=\"true\" scanPeriod=\"5 millisecond\"><include file=\"" + innerFileAsStr + "\"/></configuration> ");
        File innerFile = new File(innerFileAsStr);
        this.writeToFile(innerFile, "<included><root level=\"ERROR\"/></included> ");
        this.addResetResistantOnConsoleStatusListener();
        ReconfigurationTaskRegisteredConfigEventListener roctRegisteredListener = new ReconfigurationTaskRegisteredConfigEventListener();
        this.loggerContext.addConfigurationEventListener((ConfigurationEventListener)roctRegisteredListener);
        this.configure(topLevelFile);
        ReconfigureOnChangeTask roct = roctRegisteredListener.reconfigureOnChangeTask;
        System.out.println("===================================================");
        CountDownLatch changeDetectedLatch = this.registerChangeDetectedListener();
        CountDownLatch configurationDoneLatch = this.registerNewReconfigurationDoneListener(roct);
        this.writeToFile(innerFile, "<included>\n<root>\n</included>");
        changeDetectedLatch.await();
        configurationDoneLatch.await();
        this.addInfo("Woke from configurationDoneLatch.await()", this);
        this.statusChecker.assertContainsMatch(2, "XML_PARSING");
        this.statusChecker.assertContainsMatch(1, "Given previous errors, falling back to previously registered safe configuration.");
        this.statusChecker.assertContainsMatch(0, "Re-registering previous fallback configuration once more as a fallback configuration point");
        this.loggerContext.getStatusManager().clear();
        CountDownLatch secondDoneLatch = this.registerNewReconfigurationDoneListener();
        this.writeToFile(innerFile, "<included><root level=\"ERROR\"/></included> ");
        secondDoneLatch.await();
        this.statusChecker.assertIsErrorFree();
        this.statusChecker.containsMatch("Detected change in configuration files.");
    }

    CountDownLatch registerNewReconfigurationDoneListener() {
        return this.registerNewReconfigurationDoneListener(null);
    }

    CountDownLatch registerNewReconfigurationDoneListener(ReconfigureOnChangeTask roct) {
        CountDownLatch latch = new CountDownLatch(1);
        ReconfigurationDoneListener reconfigurationDoneListener = new ReconfigurationDoneListener(latch, roct);
        this.loggerContext.addConfigurationEventListener((ConfigurationEventListener)reconfigurationDoneListener);
        return latch;
    }

    CountDownLatch registerChangeDetectedListener() {
        CountDownLatch latch = new CountDownLatch(1);
        ChangeDetectedListener changeDetectedListener = new ChangeDetectedListener(latch);
        this.loggerContext.addConfigurationEventListener((ConfigurationEventListener)changeDetectedListener);
        return latch;
    }

    private ReconfigureOnChangeTask waitForReconfigureOnChangeTaskToRun() throws InterruptedException {
        this.addInfo("entering waitForReconfigureOnChangeTaskToRun", this);
        CountDownLatch countDownLatch = new CountDownLatch(1);
        RunMethodInvokedListener runMethodInvokedListener = new RunMethodInvokedListener(countDownLatch);
        this.loggerContext.addConfigurationEventListener((ConfigurationEventListener)runMethodInvokedListener);
        countDownLatch.await();
        return runMethodInvokedListener.reconfigureOnChangeTask;
    }

    private RunnableWithCounterAndDone[] buildRunnableArray(File configFile, UpdateType updateType) {
        RunnableWithCounterAndDone[] rArray = new RunnableWithCounterAndDone[5];
        rArray[0] = new Updater(configFile, updateType);
        for (int i = 1; i < 5; ++i) {
            rArray[i] = new LoggingRunnable((org.slf4j.Logger)this.logger);
        }
        return rArray;
    }

    @Test
    public void checkReconfigureTaskScheduledWhenDefaultScanPeriodUsed() throws JoranException {
        File file = new File(SCAN_PERIOD_DEFAULT_FILE_AS_STR);
        this.configure(file);
        List scheduledFutures = this.loggerContext.getCopyOfScheduledFutures();
        Assertions.assertFalse((boolean)scheduledFutures.isEmpty());
        this.statusChecker.containsMatch("No 'scanPeriod' specified. Defaulting to");
    }

    @Test
    @Timeout(value=4L, unit=TimeUnit.SECONDS)
    public void scan_LOGBACK_474() throws JoranException, IOException, InterruptedException {
        File file = new File(SCAN_LOGBACK_474_FILE_AS_STR);
        this.addResetResistantOnConsoleStatusListener();
        this.configure(file);
        System.out.println(" ------------ creating ReconfigureOnChangeTaskHarness");
        int expectedResets = 2;
        ReconfigureOnChangeTaskHarness harness = new ReconfigureOnChangeTaskHarness(this.loggerContext, expectedResets);
        RunnableWithCounterAndDone[] runnableArray = this.buildRunnableArray(file, UpdateType.TOUCH);
        harness.execute(runnableArray);
        this.addInfo("scan_LOGBACK_474 end of execution ", this);
        this.checkResetCount(expectedResets);
    }

    private void assertThatListContainsFile(List<File> fileList, File file) {
        Assertions.assertTrue((boolean)fileList.contains(file.getAbsoluteFile()));
    }

    private void checkResetCount(int expected) {
        StatusChecker checker = new StatusChecker((Context)this.loggerContext);
        checker.assertIsErrorFree();
        int effectiveResets = checker.matchCount("Will reset and reconfigure context ");
        Assertions.assertEquals((int)expected, (int)effectiveResets);
    }

    void addInfo(String msg, Object o) {
        this.loggerContext.getStatusManager().add((Status)new InfoStatus(msg, o));
    }

    void addWarn(String msg, Object o) {
        this.loggerContext.getStatusManager().add((Status)new WarnStatus(msg, o));
    }

    void writeToFile(File file, String contents) throws IOException {
        FileWriter fw = new FileWriter(file);
        fw.write(contents);
        fw.close();
        boolean success = file.setLastModified(System.currentTimeMillis() + (long)RandomUtil.getPositiveInt());
        if (!success) {
            this.addWarn("failed to setLastModified on file " + String.valueOf(file), this);
        }
    }

    class RunMethodInvokedListener
    implements ConfigurationEventListener {
        CountDownLatch countDownLatch;
        ReconfigureOnChangeTask reconfigureOnChangeTask;

        RunMethodInvokedListener(CountDownLatch countDownLatch) {
            this.countDownLatch = countDownLatch;
        }

        public void listen(ConfigurationEvent configurationEvent) {
            switch (configurationEvent.getEventType()) {
                case CHANGE_DETECTOR_RUNNING: {
                    this.countDownLatch.countDown();
                    Object data = configurationEvent.getData();
                    if (!(data instanceof ReconfigureOnChangeTask)) break;
                    this.reconfigureOnChangeTask = (ReconfigureOnChangeTask)data;
                    break;
                }
            }
        }
    }

    class Updater
    extends RunnableWithCounterAndDone {
        File configFile;
        UpdateType updateType;
        final int sleepBetweenUpdates = 100;

        Updater(File configFile, UpdateType updateType) {
            this.configFile = configFile;
            this.updateType = updateType;
        }

        Updater(File configFile) {
            this(configFile, UpdateType.TOUCH);
        }

        public void run() {
            while (!this.isDone()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.isDone()) {
                    ReconfigureOnChangeTaskTest.this.addInfo("Exiting Updater.run()", (Object)this);
                    return;
                }
                ++this.counter;
                ReconfigureOnChangeTaskTest.this.addInfo("Touching [" + String.valueOf(this.configFile) + "]", (Object)this);
                switch (this.updateType) {
                    case TOUCH: {
                        this.touchFile();
                        break;
                    }
                    case MALFORMED: {
                        try {
                            this.malformedUpdate();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            Assertions.fail((String)"malformedUpdate failed");
                        }
                        break;
                    }
                    case MALFORMED_INNER: {
                        try {
                            this.malformedInnerUpdate();
                            break;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            Assertions.fail((String)"malformedInnerUpdate failed");
                        }
                    }
                }
            }
            ReconfigureOnChangeTaskTest.this.addInfo("Exiting Updater.run()", (Object)this);
        }

        private void malformedUpdate() throws IOException {
            ReconfigureOnChangeTaskTest.this.writeToFile(this.configFile, "<configuration scan=\"true\" scanPeriod=\"50 millisecond\">\n  <root level=\"ERROR\">\n</configuration>");
        }

        private void malformedInnerUpdate() throws IOException {
            ReconfigureOnChangeTaskTest.this.writeToFile(this.configFile, "<included>\n  <root>\n</included>");
        }

        void touchFile() {
            boolean result = this.configFile.setLastModified(System.currentTimeMillis());
            if (!result) {
                ReconfigureOnChangeTaskTest.this.addWarn(((Object)((Object)this)).getClass().getName() + ".touchFile on " + this.configFile.toString() + " FAILED", (Object)this);
            }
        }
    }

    static enum UpdateType {
        TOUCH,
        MALFORMED,
        MALFORMED_INNER;

    }
}

