/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.net.mock;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.util.ArrayList;
import java.util.List;

public class MockSyslogServer
extends Thread {
    final int loopLen;
    final int port;
    List<byte[]> msgList = new ArrayList<byte[]>();
    boolean finished = false;

    public MockSyslogServer(int loopLen, int port) {
        this.loopLen = loopLen;
        this.port = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        DatagramSocket socket = null;
        try {
            socket = new DatagramSocket(this.port);
            for (int i = 0; i < this.loopLen; ++i) {
                byte[] buf = new byte[65536];
                DatagramPacket packet = new DatagramPacket(buf, buf.length);
                socket.receive(packet);
                byte[] out = new byte[packet.getLength()];
                System.arraycopy(buf, 0, out, 0, out.length);
                this.msgList.add(out);
            }
        }
        catch (Exception se) {
            se.printStackTrace();
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Exception exception) {}
            }
        }
        this.finished = true;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public List<byte[]> getMessageList() {
        return this.msgList;
    }
}

