/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.sift;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.sift.MDCBasedDiscriminator;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.testUtil.RandomUtil;
import java.util.HashMap;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.MDC;

public class MDCBasedDiscriminatorTest {
    static String DEFAULT_VAL = "DEFAULT_VAL";
    MDCBasedDiscriminator discriminator = new MDCBasedDiscriminator();
    LoggerContext context = new LoggerContext();
    Logger logger = this.context.getLogger(this.getClass());
    int diff = RandomUtil.getPositiveInt();
    String key = "MDCBasedDiscriminatorTest_key" + this.diff;
    String value = "MDCBasedDiscriminatorTest_val" + this.diff;
    LoggingEvent event;

    @BeforeEach
    public void setUp() {
        MDC.clear();
        this.discriminator.setContext((Context)this.context);
        this.discriminator.setKey(this.key);
        this.discriminator.setDefaultValue(DEFAULT_VAL);
        this.discriminator.start();
        Assertions.assertTrue((boolean)this.discriminator.isStarted());
    }

    @AfterEach
    public void teaDown() {
        MDC.clear();
    }

    @Test
    public void smoke() {
        MDC.put((String)this.key, (String)this.value);
        this.event = new LoggingEvent("a", this.logger, Level.DEBUG, "", null, null);
        String discriminatorValue = this.discriminator.getDiscriminatingValue((ILoggingEvent)this.event);
        Assertions.assertEquals((Object)this.value, (Object)discriminatorValue);
    }

    @Test
    public void nullMDC() {
        this.event = new LoggingEvent("a", this.logger, Level.DEBUG, "", null, null);
        Assertions.assertEquals(new HashMap(), (Object)this.event.getMDCPropertyMap());
        String discriminatorValue = this.discriminator.getDiscriminatingValue((ILoggingEvent)this.event);
        Assertions.assertEquals((Object)DEFAULT_VAL, (Object)discriminatorValue);
    }
}

