/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.joran;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.PropertiesConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.JoranConstants;
import ch.qos.logback.core.util.StatusPrinter2;
import java.util.Properties;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class PropertiesConfiguratorTest {
    LoggerContext lc = new LoggerContext();
    Properties props = new Properties();
    PropertiesConfigurator pc = new PropertiesConfigurator();
    StatusPrinter2 statusPrinter2 = new StatusPrinter2();

    PropertiesConfiguratorTest() {
    }

    @BeforeEach
    public void setup() throws Exception {
        this.pc.setContext((Context)this.lc);
    }

    @Test
    public void smoke() {
        String TOTO_STR = "toto";
        this.props.setProperty("logback.root", Level.INFO.levelStr);
        this.props.setProperty("logback.logger." + TOTO_STR, Level.ERROR.levelStr);
        this.pc.doConfigure(this.props);
        Logger rootLogger = this.lc.getLogger("ROOT");
        Logger totoLogger = this.lc.getLogger(TOTO_STR);
        Assertions.assertEquals((Object)Level.INFO, (Object)rootLogger.getLevel());
        Assertions.assertEquals((Object)Level.ERROR, (Object)totoLogger.getLevel());
    }

    @Test
    public void withVariables() {
        String TOTO_STR = "toto";
        String ROOT_LEVEL_STR = "rootLevel";
        String TOTO_LEVEL_STR = "totoLevel";
        this.props.setProperty(ROOT_LEVEL_STR, Level.INFO.levelStr);
        System.setProperty("totoLevel", Level.ERROR.levelStr);
        this.props.setProperty("logback.root", this.asVar(ROOT_LEVEL_STR));
        this.props.setProperty("logback.logger." + TOTO_STR, this.asVar(TOTO_LEVEL_STR));
        this.pc.doConfigure(this.props);
        Logger rootLogger = this.lc.getLogger("ROOT");
        Logger totoLogger = this.lc.getLogger(TOTO_STR);
        this.statusPrinter2.print((Context)this.lc);
        Assertions.assertEquals((Object)Level.INFO, (Object)rootLogger.getLevel());
        Assertions.assertEquals((Object)Level.ERROR, (Object)totoLogger.getLevel());
    }

    @Test
    void inheritedLevelString() {
        String loggerName0 = "com.abc.some0";
        String loggerName1 = "com.abc.some1";
        Logger aLogger0 = this.lc.getLogger(loggerName0);
        aLogger0.setLevel(Level.ERROR);
        Logger aLogger1 = this.lc.getLogger(loggerName1);
        aLogger1.setLevel(Level.WARN);
        this.props.setProperty("logback.logger." + loggerName0, "INHERITED");
        this.props.setProperty("logback.logger." + loggerName1, JoranConstants.NULL);
        this.pc.doConfigure(this.props);
        Assertions.assertEquals(null, (Object)aLogger0.getLevel());
        Assertions.assertEquals(null, (Object)aLogger1.getLevel());
    }

    String asVar(String v) {
        return "${" + v + "}";
    }
}

