/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.read.ListAppender;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class LoggerMessageFormattingTest {
    LoggerContext lc;
    ListAppender<ILoggingEvent> listAppender;

    @BeforeEach
    public void setUp() {
        this.lc = new LoggerContext();
        Logger logger = this.lc.getLogger("ROOT");
        this.listAppender = new ListAppender();
        this.listAppender.setContext((Context)this.lc);
        this.listAppender.start();
        logger.addAppender(this.listAppender);
    }

    @Test
    public void testFormattingOneArg() {
        Logger logger = this.lc.getLogger("ROOT");
        logger.debug("{}", (Object)12);
        ILoggingEvent event = (ILoggingEvent)this.listAppender.list.get(0);
        Assertions.assertEquals((Object)"12", (Object)event.getFormattedMessage());
    }

    @Test
    public void testFormattingTwoArg() {
        Logger logger = this.lc.getLogger("ROOT");
        logger.debug("{}-{}", (Object)12, (Object)13);
        ILoggingEvent event = (ILoggingEvent)this.listAppender.list.get(0);
        Assertions.assertEquals((Object)"12-13", (Object)event.getFormattedMessage());
    }

    @Test
    public void testNoFormatting() {
        Logger logger = this.lc.getLogger("ROOT");
        logger.debug("test", (Object)12, (Object)13);
        ILoggingEvent event = (ILoggingEvent)this.listAppender.list.get(0);
        Assertions.assertEquals((Object)"test", (Object)event.getFormattedMessage());
    }

    @Test
    public void testNoFormatting2() {
        Logger logger = this.lc.getLogger("ROOT");
        logger.debug("test");
        ILoggingEvent event = (ILoggingEvent)this.listAppender.list.get(0);
        Assertions.assertEquals((Object)"test", (Object)event.getFormattedMessage());
    }

    @Test
    public void testMessageConverter() {
        Logger logger = this.lc.getLogger("ROOT");
        logger.debug("{}", (Object)12);
        ILoggingEvent event = (ILoggingEvent)this.listAppender.list.get(0);
        PatternLayout layout = new PatternLayout();
        layout.setContext((Context)this.lc);
        layout.setPattern("%m");
        layout.start();
        String formattedMessage = layout.doLayout(event);
        Assertions.assertEquals((Object)"12", (Object)formattedMessage);
    }
}

