/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.issue.github876;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.util.LogbackMDCAdapter;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.read.ListAppender;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.spi.MDCAdapter;

public class Github876Test {
    LoggerContext loggerContext = new LoggerContext();
    LogbackMDCAdapter logbackMDCAdapter = new LogbackMDCAdapter();
    ListAppender<ILoggingEvent> listAppender = new ListAppender();
    final Logger logger = this.loggerContext.getLogger(Github876Test.class);

    @BeforeEach
    public void setUp() {
        this.loggerContext.setMDCAdapter((MDCAdapter)this.logbackMDCAdapter);
        this.listAppender.setContext((Context)this.loggerContext);
        this.listAppender.setName("list");
        this.listAppender.start();
        this.logger.addAppender(this.listAppender);
    }

    @Test
    public void traditionalTest() {
        Exception ex = new Exception("Some message");
        this.logger.error("Exception Message: {}", (Object)ex, (Object)ex);
        Assertions.assertEquals((int)1, (int)this.listAppender.list.size());
        ILoggingEvent iLoggingEvent0 = (ILoggingEvent)this.listAppender.list.get(0);
        String formattedMessage0 = iLoggingEvent0.getFormattedMessage();
        Assertions.assertEquals((Object)"Exception Message: java.lang.Exception: Some message", (Object)formattedMessage0);
    }

    @Test
    public void fluentTest() {
        Exception ex = new Exception("Some message");
        this.logger.atError().addArgument((Object)ex).setCause((Throwable)ex).setMessage("Exception Message: {}").log();
        Assertions.assertEquals((int)1, (int)this.listAppender.list.size());
        ILoggingEvent iLoggingEvent0 = (ILoggingEvent)this.listAppender.list.get(0);
        String formattedMessage0 = iLoggingEvent0.getFormattedMessage();
        Assertions.assertEquals((Object)"Exception Message: java.lang.Exception: Some message", (Object)formattedMessage0);
    }
}

