/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.pattern.XCompositeConverter;
import ch.qos.logback.classic.pattern.XThrowableHandlingConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.Context;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class EnsureExceptionHandlingTest {
    private PatternLayout pl = new PatternLayout();
    private LoggerContext lc = new LoggerContext();
    Logger logger = this.lc.getLogger(this.getClass());
    static final String XTH = "xth";
    static final String XCC = "xcc";

    @BeforeEach
    public void setUp() {
        this.pl.setContext((Context)this.lc);
        this.pl.getInstanceConverterMap().put(XTH, XThrowableHandlingConverter::new);
        this.pl.getInstanceConverterMap().put(XCC, XCompositeConverter::new);
    }

    ILoggingEvent makeLoggingEvent(String msg, Exception ex) {
        return new LoggingEvent(EnsureExceptionHandlingTest.class.getName(), this.logger, Level.INFO, msg, (Throwable)ex, null);
    }

    @Test
    public void smoke() {
        this.pl.setPattern("%m %xth)");
        this.pl.start();
        ILoggingEvent le = this.makeLoggingEvent("assert", null);
        this.pl.doLayout(le);
    }

    @Test
    public void withinComposite() {
        this.pl.setPattern("%m %xcc(%xth)");
        this.pl.start();
        ILoggingEvent le = this.makeLoggingEvent("assert", null);
        this.pl.doLayout(le);
    }
}

