/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.pattern.LevelConverter;
import ch.qos.logback.classic.pattern.SubPatternLayout;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.Context;
import java.util.HashMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LegacyPatternLayoutTest {
    LoggerContext context = new LoggerContext();

    @Test
    public void subPattern() {
        SubPatternLayout layout = new SubPatternLayout();
        layout.setPattern("%" + SubPatternLayout.DOOO);
        layout.setContext((Context)this.context);
        layout.start();
        LoggingEvent event = new LoggingEvent();
        event.setTimeStamp(0L);
        String result = layout.doLayout((ILoggingEvent)event);
        Assertions.assertEquals((Object)"1970-01-01 01:00:00,000", (Object)result);
    }

    @Test
    public void fromContext() {
        HashMap<String, String> registry = (HashMap<String, String>)this.context.getObject("PATTERN_RULE_REGISTRY");
        Assertions.assertNull((Object)registry);
        if (registry == null) {
            registry = new HashMap<String, String>();
            this.context.putObject("PATTERN_RULE_REGISTRY", registry);
        }
        registry.put("legacy", LevelConverter.class.getName());
        PatternLayout patternLayout = new PatternLayout();
        patternLayout.setPattern("%legacy");
        patternLayout.setContext((Context)this.context);
        patternLayout.start();
        LoggingEvent event = new LoggingEvent();
        event.setLevel(Level.WARN);
        String result = patternLayout.doLayout((ILoggingEvent)event);
        Assertions.assertEquals((Object)"WARN", (Object)result);
    }
}

