/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.pattern.MaskedKeyValuePairConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.status.testUtil.StatusChecker;
import ch.qos.logback.core.util.StatusPrinter2;
import java.util.List;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.event.KeyValuePair;

public class MaskedKeyValuePairConverterTest {
    LoggerContext lc = new LoggerContext();
    MaskedKeyValuePairConverter converter;
    LoggingEvent event;
    StatusChecker statusChecker = new StatusChecker((Context)this.lc);
    StatusPrinter2 statusPrinter2 = new StatusPrinter2();

    @BeforeEach
    public void setUp() throws Exception {
        this.converter = new MaskedKeyValuePairConverter();
        this.converter.setContext((Context)this.lc);
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.lc = null;
        this.converter.stop();
        this.converter = null;
    }

    @Test
    public void smoke() {
        this.event = this.createLoggingEvent();
        this.converter.setOptionList(List.of("k1"));
        this.converter.start();
        this.event.addKeyValuePair(new KeyValuePair("k1", (Object)"v1"));
        this.event.addKeyValuePair(new KeyValuePair("k2", (Object)"v2"));
        String result = this.converter.convert((ILoggingEvent)this.event);
        Assertions.assertEquals((Object)"k1=\"XXX\" k2=\"v2\"", (Object)result);
    }

    @Test
    public void smokeSingle() {
        this.event = this.createLoggingEvent();
        this.converter.setOptionList(List.of("SINGLE", "k1"));
        this.converter.start();
        this.event.addKeyValuePair(new KeyValuePair("k1", (Object)"v1"));
        this.event.addKeyValuePair(new KeyValuePair("k2", (Object)"v2"));
        String result = this.converter.convert((ILoggingEvent)this.event);
        Assertions.assertEquals((Object)"k1='XXX' k2='v2'", (Object)result);
    }

    @Test
    public void wrongOrder() {
        this.event = this.createLoggingEvent();
        this.converter.setOptionList(List.of("k1", "SINGLE"));
        this.converter.start();
        this.event.addKeyValuePair(new KeyValuePair("k1", (Object)"v1"));
        this.event.addKeyValuePair(new KeyValuePair("k2", (Object)"v2"));
        this.statusPrinter2.print((Context)this.lc);
        this.statusChecker.assertContainsMatch(1, "extra quote spec SINGLE found in the wrong order");
        String result = this.converter.convert((ILoggingEvent)this.event);
        Assertions.assertEquals((Object)"k1=\"XXX\" k2=\"v2\"", (Object)result);
    }

    @Test
    public void testWithOnelKVP() {
        this.event = this.createLoggingEvent();
        this.converter.setOptionList(List.of("k"));
        this.converter.start();
        this.event.addKeyValuePair(new KeyValuePair("k", (Object)"v"));
        String result = this.converter.convert((ILoggingEvent)this.event);
        Assertions.assertEquals((Object)"k=\"XXX\"", (Object)result);
    }

    private LoggingEvent createLoggingEvent() {
        LoggingEvent le = new LoggingEvent(this.getClass().getName(), this.lc.getLogger("ROOT"), Level.DEBUG, "test message", null, null);
        return le;
    }
}

