/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.sift;

import ch.qos.logback.classic.ClassicConstants;
import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.sift.MDCBasedDiscriminator;
import ch.qos.logback.classic.sift.SiftingAppender;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.classic.util.LogbackMDCAdapter;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.read.ListAppender;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.SizeAndTimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.TimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.sift.AppenderFactory;
import ch.qos.logback.core.sift.AppenderTracker;
import ch.qos.logback.core.sift.Discriminator;
import ch.qos.logback.core.status.testUtil.StatusChecker;
import ch.qos.logback.core.testUtil.RandomUtil;
import ch.qos.logback.core.testUtil.StringListAppender;
import ch.qos.logback.core.util.FileSize;
import java.util.List;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.slf4j.spi.MDCAdapter;

public class SiftingAppenderTest {
    static String SIFT_FOLDER_PREFIX = "src/test/input/joran/sift/";
    LoggerContext loggerContext = new LoggerContext();
    LogbackMDCAdapter logbackMDCAdapter = new LogbackMDCAdapter();
    Logger logger = this.loggerContext.getLogger(this.getClass().getName());
    Logger root = this.loggerContext.getLogger("ROOT");
    StatusChecker statusChecker = new StatusChecker((Context)this.loggerContext);
    int diff = RandomUtil.getPositiveInt();
    String randomOutputDir = "target/test-output/" + this.diff + "/";
    int now = 0;

    protected void configure(String file) throws JoranException {
        JoranConfigurator jc = new JoranConfigurator();
        jc.setContext((Context)this.loggerContext);
        jc.doConfigure(file);
    }

    @BeforeEach
    public void setUp() {
        this.loggerContext.setMDCAdapter((MDCAdapter)this.logbackMDCAdapter);
    }

    @AfterEach
    public void tearDown() {
    }

    @Test
    public void unsetDefaultValueProperty() throws JoranException {
        this.configure(SIFT_FOLDER_PREFIX + "unsetDefaultValueProperty.xml");
        this.logger.debug("hello");
        SiftingAppender sa = (SiftingAppender)this.root.getAppender("SIFT");
        Assertions.assertFalse((boolean)sa.isStarted());
    }

    @Test
    public void smoke() throws JoranException {
        this.configure(SIFT_FOLDER_PREFIX + "smoke.xml");
        this.logger.debug("smoke");
        Appender appender = (Appender)this.getAppenderTracker().find("smokeDefault");
        Assertions.assertNotNull((Object)appender);
        ListAppender listAppender = (ListAppender)appender;
        List eventList = listAppender.list;
        Assertions.assertEquals((int)1, (int)listAppender.list.size());
        Assertions.assertEquals((Object)"smoke", (Object)((ILoggingEvent)eventList.get(0)).getMessage());
        this.statusChecker.assertIsWarningOrErrorFree();
    }

    private AppenderTracker<ILoggingEvent> getAppenderTracker() {
        SiftingAppender ha = (SiftingAppender)this.root.getAppender("SIFT");
        return ha.getAppenderTracker();
    }

    @Test
    public void zeroNesting() throws JoranException {
        this.configure(SIFT_FOLDER_PREFIX + "zeroNesting.xml");
        this.logger.debug("hello");
        this.logger.debug("hello");
        this.logger.debug("hello");
        this.logger.debug("hello");
        this.logger.debug("hello");
        Assertions.assertNull(this.getAppenderTracker());
        this.statusChecker.assertContainsMatch(2, "No nested appenders found");
    }

    @Test
    public void multipleNesting() throws JoranException {
        this.configure(SIFT_FOLDER_PREFIX + "multipleNesting.xml");
        this.logger.debug("hello");
        this.logger.debug("hello");
        this.logger.debug("hello");
        Assertions.assertNull(this.getAppenderTracker());
        this.statusChecker.assertContainsMatch(2, "Only and only one appender can be nested");
    }

    @Test
    public void defaultLayoutRule() throws JoranException {
        this.configure(SIFT_FOLDER_PREFIX + "defaultLayoutRule.xml");
        this.logger.debug("hello");
        SiftingAppender ha = (SiftingAppender)this.root.getAppender("SIFT");
        StringListAppender listAppender = (StringListAppender)ha.getAppenderTracker().find("default");
        Assertions.assertNotNull((Object)listAppender);
        List strList = listAppender.strList;
        Assertions.assertEquals((int)1, (int)strList.size());
        Assertions.assertEquals((Object)"DEBUG hello", strList.get(0));
    }

    @Test
    public void fileAppenderCollision() throws JoranException, InterruptedException {
        this.loggerContext.putProperty("DIR_PREFIX", this.randomOutputDir);
        String key = "collision";
        this.configure(SIFT_FOLDER_PREFIX + "fileAppender.xml");
        SiftingAppender sa = (SiftingAppender)this.root.getAppender("SIFT");
        long timestamp = System.currentTimeMillis();
        this.logbackMDCAdapter.put(key, "A-" + this.diff);
        this.logNewEventViaSiftingAppender(sa, timestamp);
        FileAppender fileAppenderA = (FileAppender)sa.getAppenderTracker().find("A-" + this.diff);
        Assertions.assertNotNull((Object)fileAppenderA);
        Assertions.assertTrue((boolean)fileAppenderA.isStarted());
        this.logbackMDCAdapter.put(key, "B-" + this.diff);
        this.logNewEventViaSiftingAppender(sa, timestamp += 1800001L);
        Assertions.assertFalse((boolean)fileAppenderA.isStarted());
        this.logbackMDCAdapter.put(key, "A-" + this.diff);
        this.logNewEventViaSiftingAppender(sa, ++timestamp);
        FileAppender fileAppenderA_2 = (FileAppender)sa.getAppenderTracker().find("A-" + this.diff);
        Assertions.assertTrue((boolean)fileAppenderA_2.isStarted());
    }

    private void logNewEventViaSiftingAppender(SiftingAppender sa, long timestamp) {
        LoggingEvent le = new LoggingEvent("x", this.logger, Level.INFO, "hello", null, null);
        le.setTimeStamp(timestamp + 1800000L + 1L);
        sa.doAppend((Object)le);
    }

    @Test
    public void testWholeCycle() throws JoranException {
        String mdcKey = "cycle";
        this.configure(SIFT_FOLDER_PREFIX + "completeCycle.xml");
        this.logbackMDCAdapter.put(mdcKey, "a");
        this.logger.debug("smoke");
        long timestamp = System.currentTimeMillis();
        SiftingAppender sa = (SiftingAppender)this.root.getAppender("SIFT");
        ListAppender listAppender = (ListAppender)sa.getAppenderTracker().find("a");
        Assertions.assertNotNull((Object)listAppender);
        List eventList = listAppender.list;
        Assertions.assertEquals((int)1, (int)listAppender.list.size());
        Assertions.assertEquals((Object)"smoke", (Object)((ILoggingEvent)eventList.get(0)).getMessage());
        this.logbackMDCAdapter.remove(mdcKey);
        this.logNewEventViaSiftingAppender(sa, timestamp);
        Assertions.assertFalse((boolean)listAppender.isStarted());
        Assertions.assertEquals((int)1, (int)sa.getAppenderTracker().allKeys().size());
        Assertions.assertTrue((boolean)sa.getAppenderTracker().allKeys().contains("cycleDefault"));
    }

    @Test
    public void sessionFinalizationShouldCauseLingering() throws JoranException {
        String mdcKey = "linger";
        String mdcVal = "session" + this.diff;
        this.configure(SIFT_FOLDER_PREFIX + "lingering.xml");
        this.logbackMDCAdapter.put(mdcKey, mdcVal);
        this.logger.debug("linger 1");
        this.logger.debug(ClassicConstants.FINALIZE_SESSION_MARKER, "linger 2");
        long now = System.currentTimeMillis();
        SiftingAppender sa = (SiftingAppender)this.root.getAppender("SIFT");
        AppenderTracker tracker = sa.getAppenderTracker();
        Assertions.assertEquals((int)1, (int)tracker.allKeys().size());
        Appender appender = (Appender)tracker.find(mdcVal);
        Assertions.assertTrue((boolean)appender.isStarted());
        tracker.removeStaleComponents(now + 10000L + 1L);
        Assertions.assertFalse((boolean)appender.isStarted());
        Assertions.assertEquals((int)0, (int)tracker.allKeys().size());
    }

    @Test
    public void localPropertiesShouldBeVisible() throws JoranException {
        String mdcKey = "localProperty";
        String mdcVal = "" + this.diff;
        String msg = "localPropertiesShouldBeVisible";
        String prefix = "Y";
        this.configure(SIFT_FOLDER_PREFIX + "propertyPropagation.xml");
        this.logbackMDCAdapter.put(mdcKey, mdcVal);
        this.logger.debug(msg);
        SiftingAppender sa = (SiftingAppender)this.root.getAppender("SIFT");
        StringListAppender listAppender = (StringListAppender)sa.getAppenderTracker().find(mdcVal);
        Assertions.assertNotNull((Object)listAppender);
        List strList = listAppender.strList;
        Assertions.assertEquals((int)1, (int)listAppender.strList.size());
        Assertions.assertEquals((Object)(prefix + msg), strList.get(0));
    }

    @Test
    public void propertyDefinedWithinSiftElementShouldBeVisible() throws JoranException {
        String mdcKey = "propertyDefinedWithinSift";
        String mdcVal = "" + this.diff;
        String msg = "propertyDefinedWithinSiftElementShouldBeVisible";
        String prefix = "Y";
        this.configure(SIFT_FOLDER_PREFIX + "propertyDefinedInSiftElement.xml");
        this.logbackMDCAdapter.put(mdcKey, mdcVal);
        this.logger.debug(msg);
        SiftingAppender sa = (SiftingAppender)this.root.getAppender("SIFT");
        StringListAppender listAppender = (StringListAppender)sa.getAppenderTracker().find(mdcVal);
        Assertions.assertNotNull((Object)listAppender);
        List strList = listAppender.strList;
        Assertions.assertEquals((int)1, (int)listAppender.strList.size());
        Assertions.assertEquals((Object)(prefix + msg), strList.get(0));
    }

    @Test
    public void compositePropertyShouldCombineWithinAndWithoutSiftElement() throws JoranException {
        String mdcKey = "compositeProperty";
        String mdcVal = "" + this.diff;
        String msg = "compositePropertyShouldCombineWithinAndWithoutSiftElement";
        String prefix = "composite";
        this.configure(SIFT_FOLDER_PREFIX + "compositeProperty.xml");
        this.logbackMDCAdapter.put(mdcKey, mdcVal);
        this.logger.debug(msg);
        SiftingAppender sa = (SiftingAppender)this.root.getAppender("SIFT");
        StringListAppender listAppender = (StringListAppender)sa.getAppenderTracker().find(mdcVal);
        Assertions.assertNotNull((Object)listAppender);
        List strList = listAppender.strList;
        Assertions.assertEquals((int)1, (int)listAppender.strList.size());
        Assertions.assertEquals((Object)(prefix + msg), strList.get(0));
    }

    @Test
    public void maxAppendersCountPropertyShouldBeHonored() throws JoranException {
        this.configure(SIFT_FOLDER_PREFIX + "maxAppenderCount.xml");
        int max = 5;
        SiftingAppender sa = (SiftingAppender)this.root.getAppender("SIFT");
        String mdcKey = "max";
        for (int i = 0; i <= max; ++i) {
            this.logbackMDCAdapter.put(mdcKey, "" + (this.diff + i));
            LoggingEvent event = new LoggingEvent("", this.logger, Level.DEBUG, "max" + i, null, null);
            event.setTimeStamp((long)this.now);
            sa.doAppend((Object)event);
            this.now = (int)((long)this.now + 1000L);
        }
        AppenderTracker tracker = sa.getAppenderTracker();
        Assertions.assertEquals((int)max, (int)tracker.allKeys().size());
        Assertions.assertNull((Object)tracker.find("" + (this.diff + 0)));
        for (int i = 1; i <= max; ++i) {
            Assertions.assertNotNull((Object)tracker.find("" + (this.diff + i)));
        }
    }

    @Test
    public void timeoutPropertyShouldBeHonored() throws JoranException, InterruptedException {
        this.configure(SIFT_FOLDER_PREFIX + "timeout.xml");
        long timeout = 30000L;
        SiftingAppender sa = (SiftingAppender)this.root.getAppender("SIFT");
        LoggingEvent event = new LoggingEvent("", this.logger, Level.DEBUG, "timeout", null, null);
        event.setTimeStamp((long)this.now);
        sa.doAppend((Object)event);
        AppenderTracker tracker = sa.getAppenderTracker();
        Assertions.assertEquals((int)1, (int)tracker.getComponentCount());
        this.now = (int)((long)this.now + (timeout + 1L));
        tracker.removeStaleComponents((long)this.now);
        Assertions.assertEquals((int)0, (int)tracker.getComponentCount());
        this.statusChecker.assertIsErrorFree();
    }

    @Disabled
    @Test
    public void programmicSiftingAppender() {
        SiftingAppender connectorAppender = new SiftingAppender();
        connectorAppender.setContext((Context)this.loggerContext);
        connectorAppender.setName("SIFTING_APPENDER");
        MDCBasedDiscriminator discriminator = new MDCBasedDiscriminator();
        discriminator.setKey("SKEY");
        discriminator.setDefaultValue("DEF_KEY");
        discriminator.start();
        connectorAppender.setDiscriminator((Discriminator)discriminator);
        connectorAppender.setAppenderFactory((AppenderFactory)new AppenderFactory<ILoggingEvent>(){

            public Appender<ILoggingEvent> buildAppender(Context context, String discriminatingValue) throws JoranException {
                RollingFileAppender appender = new RollingFileAppender();
                appender.setName("ROLLING_APPENDER_" + discriminatingValue);
                appender.setContext(context);
                appender.setFile("/var/logs/active_" + discriminatingValue + ".log");
                TimeBasedRollingPolicy policy = new TimeBasedRollingPolicy();
                policy.setContext(context);
                policy.setMaxHistory(365);
                policy.setFileNamePattern("target/test-output//logback1127/" + discriminatingValue + "_%d{yyyy_MM_dd}_%i.log");
                policy.setParent((FileAppender)appender);
                policy.setCleanHistoryOnStart(true);
                SizeAndTimeBasedFileNamingAndTriggeringPolicy innerpolicy = new SizeAndTimeBasedFileNamingAndTriggeringPolicy();
                innerpolicy.setContext(context);
                innerpolicy.setMaxFileSize(FileSize.valueOf((String)"5KB"));
                innerpolicy.setTimeBasedRollingPolicy(policy);
                policy.setTimeBasedFileNamingAndTriggeringPolicy((TimeBasedFileNamingAndTriggeringPolicy)innerpolicy);
                policy.start();
                appender.setRollingPolicy((RollingPolicy)policy);
                PatternLayoutEncoder pl = new PatternLayoutEncoder();
                pl.setContext(context);
                pl.setPattern("%d{yyyy/MM/dd'T'HH:mm:ss} %-5level - %msg\n");
                pl.start();
                appender.setEncoder((Encoder)pl);
                appender.start();
                return appender;
            }
        });
        connectorAppender.start();
        Logger logger = this.loggerContext.getLogger("org.test");
        logger.addAppender((Appender)connectorAppender);
        logger.setLevel(Level.DEBUG);
        logger.setAdditive(false);
        this.logbackMDCAdapter.put("SKEY", "K1");
        logger.info("bla1");
        this.logbackMDCAdapter.clear();
        this.logbackMDCAdapter.put("SKEY", "K2");
        logger.info("bla2");
        this.logbackMDCAdapter.clear();
    }
}

