/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.jsonTest;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.event.KeyValuePair;

public class KeyValuePairDeserializer
extends StdDeserializer<KeyValuePair> {
    public KeyValuePairDeserializer() {
        this(null);
    }

    public KeyValuePairDeserializer(Class<?> vc) {
        super(vc);
    }

    public KeyValuePair deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JacksonException {
        Iterator it;
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        if (node.isObject() && (it = node.fields()).hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            String key = (String)entry.getKey();
            String value = ((JsonNode)entry.getValue()).asText();
            KeyValuePair kvp = new KeyValuePair(key, (Object)value);
            return kvp;
        }
        return null;
    }
}

