/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.jsonTest;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.LoggerContextVO;
import ch.qos.logback.classic.spi.PubThrowableProxy;
import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.List;
import java.util.Map;
import org.slf4j.Marker;
import org.slf4j.event.KeyValuePair;
import org.slf4j.helpers.MessageFormatter;

@JsonIgnoreProperties(value={})
public class JsonLoggingEvent
implements ILoggingEvent {
    public String threadName;
    public String loggerName;
    @JsonAlias(value={"context"})
    public LoggerContextVO loggerContextVO;
    public Level level;
    public String message;
    private String formattedMessage;
    @JsonAlias(value={"arguments"})
    public Object[] argumentArray;
    @JsonAlias(value={"throwable"})
    public PubThrowableProxy throwableProxy;
    @JsonIgnore
    public StackTraceElement[] callerDataArray;
    @JsonAlias(value={"markers"})
    public List<Marker> markerList;
    @JsonAlias(value={"kvp"})
    public List<KeyValuePair> kvpList;
    @JsonAlias(value={"mdc"})
    public Map<String, String> mdcPropertyMap;
    public long timestamp;
    public int nanoseconds;
    public long sequenceNumber;

    public String getThreadName() {
        return this.threadName;
    }

    public LoggerContextVO getLoggerContextVO() {
        return this.loggerContextVO;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level aLavel) {
        this.level = aLavel;
    }

    public String getMessage() {
        return this.message;
    }

    public String getFormattedMessage() {
        if (this.formattedMessage != null) {
            return this.formattedMessage;
        }
        this.formattedMessage = this.argumentArray != null ? MessageFormatter.arrayFormat((String)this.message, (Object[])this.argumentArray).getMessage() : this.message;
        return this.formattedMessage;
    }

    public Object[] getArgumentArray() {
        return this.argumentArray;
    }

    public IThrowableProxy getThrowableProxy() {
        return this.throwableProxy;
    }

    public StackTraceElement[] getCallerData() {
        return this.callerDataArray;
    }

    public boolean hasCallerData() {
        return this.callerDataArray != null;
    }

    public List<Marker> getMarkerList() {
        return this.markerList;
    }

    public long getTimeStamp() {
        return this.timestamp;
    }

    public int getNanoseconds() {
        return this.nanoseconds;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(long sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public long getContextBirthTime() {
        return this.loggerContextVO.getBirthTime();
    }

    public LoggerContextVO getContextLoggerRemoteView() {
        return this.loggerContextVO;
    }

    public Map<String, String> getMDCPropertyMap() {
        return this.mdcPropertyMap;
    }

    public Map<String, String> getMdc() {
        return this.mdcPropertyMap;
    }

    public void setMdc(Map<String, String> map) {
        this.mdcPropertyMap = map;
    }

    public void prepareForDeferredProcessing() {
    }

    public List<KeyValuePair> getKeyValuePairs() {
        return this.kvpList;
    }

    public void setKeyValuePairs(List<KeyValuePair> aList) {
        this.kvpList = aList;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.timestamp);
        sb.append(" ");
        sb.append(this.level);
        sb.append(" [");
        sb.append(this.threadName);
        sb.append("] ");
        sb.append(this.loggerName);
        sb.append(" - ");
        sb.append(this.getFormattedMessage());
        return sb.toString();
    }
}

