/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.jsonTest;

import ch.qos.logback.classic.spi.StackTraceElementProxy;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.node.IntNode;
import java.io.IOException;

public class STEPDeserializer
extends StdDeserializer<StackTraceElementProxy> {
    public STEPDeserializer() {
        this(null);
    }

    public STEPDeserializer(Class<?> vc) {
        super(vc);
    }

    public StackTraceElementProxy deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        return STEPDeserializer.jsonNodeToSTEP(node);
    }

    public static StackTraceElementProxy jsonNodeToSTEP(JsonNode node) {
        String className = node.get("className").asText();
        String methodName = node.get("methodName").asText();
        String fileName = node.get("fileName").asText();
        int lineNumber = (Integer)((IntNode)node.get("lineNumber")).numberValue();
        StackTraceElement ste = new StackTraceElement(className, methodName, fileName, lineNumber);
        return new StackTraceElementProxy(ste);
    }
}

