/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.multiJVM;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.multiJVM.LoggingThread;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;

public class SafeModeFileAppender {
    static long LEN;
    static String FILENAME;
    static String STAMP;

    public static void main(String[] argv) throws Exception {
        if (argv.length != 3) {
            SafeModeFileAppender.usage("Wrong number of arguments.");
        }
        STAMP = argv[0];
        LEN = Integer.parseInt(argv[1]);
        FILENAME = argv[2];
        SafeModeFileAppender.writeContinously(STAMP, FILENAME, true);
    }

    static void usage(String msg) {
        System.err.println(msg);
        System.err.println("Usage: java " + SafeModeFileAppender.class.getName() + " stamp runLength filename\n stamp JVM instance stamp\n   runLength (integer) the number of logs to generate perthread    filename (string) the filename where to write\n");
        System.exit(1);
    }

    static LoggerContext buildLoggerContext(String stamp, String filename, boolean safetyMode) {
        LoggerContext loggerContext = new LoggerContext();
        FileAppender fa = new FileAppender();
        PatternLayoutEncoder patternLayout = new PatternLayoutEncoder();
        patternLayout.setPattern(stamp + " %5p - %m%n");
        patternLayout.setContext((Context)loggerContext);
        patternLayout.start();
        fa.setEncoder((Encoder)patternLayout);
        fa.setFile(filename);
        fa.setAppend(true);
        fa.setPrudent(safetyMode);
        fa.setContext((Context)loggerContext);
        fa.start();
        Logger root = loggerContext.getLogger("ROOT");
        root.addAppender((Appender)fa);
        return loggerContext;
    }

    static void writeContinously(String stamp, String filename, boolean safetyMode) throws Exception {
        LoggerContext lc = SafeModeFileAppender.buildLoggerContext(stamp, filename, safetyMode);
        Logger logger = lc.getLogger(SafeModeFileAppender.class);
        long before = System.nanoTime();
        int i = 0;
        while ((long)i < LEN) {
            logger.debug(LoggingThread.msgLong + " " + i);
            ++i;
        }
        lc.stop();
        double durationPerLog = (double)(System.nanoTime() - before) / ((double)LEN * 1000.0);
        System.out.println("Average duration of " + durationPerLog + " microseconds per log. Safety mode " + safetyMode);
        System.out.println("------------------------------------------------");
    }
}

