/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.pattern.MarkerConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.IMarkerFactory;
import org.slf4j.Marker;
import org.slf4j.helpers.BasicMarkerFactory;

public class MarkerConverterTest {
    LoggerContext lc;
    MarkerConverter converter;
    IMarkerFactory markerFactory = new BasicMarkerFactory();

    @BeforeEach
    public void setUp() throws Exception {
        this.lc = new LoggerContext();
        this.converter = new MarkerConverter();
        this.converter.start();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.lc = null;
        this.converter.stop();
        this.converter = null;
    }

    @Test
    public void testWithNullMarker() {
        String result = this.converter.convert(this.createLoggingEvent(null));
        Assertions.assertEquals((Object)"", (Object)result);
    }

    @Test
    public void testWithMarker() {
        String name = "test";
        Marker marker = this.markerFactory.getMarker(name);
        String result = this.converter.convert(this.createLoggingEvent(marker));
        Assertions.assertEquals((Object)name, (Object)result);
    }

    @Test
    public void testWithOneChildMarker() {
        Marker marker = this.markerFactory.getMarker("test");
        marker.add(this.markerFactory.getMarker("child"));
        String result = this.converter.convert(this.createLoggingEvent(marker));
        Assertions.assertEquals((Object)"test [ child ]", (Object)result);
    }

    @Test
    public void testWithSeveralChildMarker() {
        Marker marker = this.markerFactory.getMarker("testParent");
        marker.add(this.markerFactory.getMarker("child1"));
        marker.add(this.markerFactory.getMarker("child2"));
        marker.add(this.markerFactory.getMarker("child3"));
        String result = this.converter.convert(this.createLoggingEvent(marker));
        Assertions.assertEquals((Object)"testParent [ child1, child2, child3 ]", (Object)result);
    }

    private ILoggingEvent createLoggingEvent(Marker marker) {
        LoggingEvent le = new LoggingEvent(this.getClass().getName(), this.lc.getLogger("ROOT"), Level.DEBUG, "test message", null, null);
        le.addMarker(marker);
        return le;
    }
}

