/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.pattern.TargetLengthBasedClassNameAbbreviator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TargetLengthBasedClassNameAbbreviatorTest {
    @Test
    public void testShortName() {
        TargetLengthBasedClassNameAbbreviator abbreviator = new TargetLengthBasedClassNameAbbreviator(100);
        String name = "hello";
        Assertions.assertEquals((Object)name, (Object)abbreviator.abbreviate(name));
        abbreviator = new TargetLengthBasedClassNameAbbreviator(100);
        name = "hello.world";
        Assertions.assertEquals((Object)name, (Object)abbreviator.abbreviate(name));
    }

    @Test
    public void testNoDot() {
        TargetLengthBasedClassNameAbbreviator abbreviator = new TargetLengthBasedClassNameAbbreviator(1);
        String name = "hello";
        Assertions.assertEquals((Object)name, (Object)abbreviator.abbreviate(name));
    }

    @Test
    public void testOneDot() {
        TargetLengthBasedClassNameAbbreviator abbreviator = new TargetLengthBasedClassNameAbbreviator(1);
        String name = "hello.world";
        Assertions.assertEquals((Object)"h.world", (Object)abbreviator.abbreviate(name));
        abbreviator = new TargetLengthBasedClassNameAbbreviator(1);
        name = "h.world";
        Assertions.assertEquals((Object)"h.world", (Object)abbreviator.abbreviate(name));
        abbreviator = new TargetLengthBasedClassNameAbbreviator(1);
        name = ".world";
        Assertions.assertEquals((Object)".world", (Object)abbreviator.abbreviate(name));
    }

    @Test
    public void testTwoDot() {
        TargetLengthBasedClassNameAbbreviator abbreviator = new TargetLengthBasedClassNameAbbreviator(1);
        String name = "com.logback.Foobar";
        Assertions.assertEquals((Object)"c.l.Foobar", (Object)abbreviator.abbreviate(name));
        abbreviator = new TargetLengthBasedClassNameAbbreviator(1);
        name = "c.logback.Foobar";
        Assertions.assertEquals((Object)"c.l.Foobar", (Object)abbreviator.abbreviate(name));
        abbreviator = new TargetLengthBasedClassNameAbbreviator(1);
        name = "c..Foobar";
        Assertions.assertEquals((Object)"c..Foobar", (Object)abbreviator.abbreviate(name));
        abbreviator = new TargetLengthBasedClassNameAbbreviator(1);
        name = "..Foobar";
        Assertions.assertEquals((Object)"..Foobar", (Object)abbreviator.abbreviate(name));
    }

    @Test
    public void test3Dot() {
        TargetLengthBasedClassNameAbbreviator abbreviator = new TargetLengthBasedClassNameAbbreviator(1);
        String name = "com.logback.xyz.Foobar";
        Assertions.assertEquals((Object)"c.l.x.Foobar", (Object)abbreviator.abbreviate(name));
        abbreviator = new TargetLengthBasedClassNameAbbreviator(13);
        name = "com.logback.xyz.Foobar";
        Assertions.assertEquals((Object)"c.l.x.Foobar", (Object)abbreviator.abbreviate(name));
        abbreviator = new TargetLengthBasedClassNameAbbreviator(14);
        name = "com.logback.xyz.Foobar";
        Assertions.assertEquals((Object)"c.l.xyz.Foobar", (Object)abbreviator.abbreviate(name));
        abbreviator = new TargetLengthBasedClassNameAbbreviator(15);
        name = "com.logback.alligator.Foobar";
        Assertions.assertEquals((Object)"c.l.a.Foobar", (Object)abbreviator.abbreviate(name));
    }

    @Test
    public void testXDot() {
        TargetLengthBasedClassNameAbbreviator abbreviator = new TargetLengthBasedClassNameAbbreviator(21);
        String name = "com.logback.wombat.alligator.Foobar";
        Assertions.assertEquals((Object)"c.l.w.a.Foobar", (Object)abbreviator.abbreviate(name));
        abbreviator = new TargetLengthBasedClassNameAbbreviator(22);
        name = "com.logback.wombat.alligator.Foobar";
        Assertions.assertEquals((Object)"c.l.w.alligator.Foobar", (Object)abbreviator.abbreviate(name));
        abbreviator = new TargetLengthBasedClassNameAbbreviator(1);
        name = "com.logback.wombat.alligator.tomato.Foobar";
        Assertions.assertEquals((Object)"c.l.w.a.t.Foobar", (Object)abbreviator.abbreviate(name));
        abbreviator = new TargetLengthBasedClassNameAbbreviator(21);
        name = "com.logback.wombat.alligator.tomato.Foobar";
        Assertions.assertEquals((Object)"c.l.w.a.tomato.Foobar", (Object)abbreviator.abbreviate(name));
        abbreviator = new TargetLengthBasedClassNameAbbreviator(29);
        name = "com.logback.wombat.alligator.tomato.Foobar";
        Assertions.assertEquals((Object)"c.l.w.alligator.tomato.Foobar", (Object)abbreviator.abbreviate(name));
    }
}

