/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.turbo;

import ch.qos.logback.classic.turbo.MDCFilter;
import ch.qos.logback.core.spi.FilterReply;
import ch.qos.logback.core.testUtil.RandomUtil;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.MDC;

public class MDCFilterTest {
    int diff = RandomUtil.getPositiveInt();
    String key = "myKey" + this.diff;
    String value = "val" + this.diff;
    private MDCFilter filter;

    @BeforeEach
    public void setUp() {
        this.filter = new MDCFilter();
        this.filter.setOnMatch("ACCEPT");
        this.filter.setOnMismatch("DENY");
        this.filter.setMDCKey(this.key);
        this.filter.setValue(this.value);
        MDC.clear();
    }

    @AfterEach
    public void tearDown() {
        MDC.clear();
    }

    @Test
    public void smoke() {
        this.filter.start();
        MDC.put((String)this.key, (String)("other" + this.diff));
        Assertions.assertEquals((Object)FilterReply.DENY, (Object)this.filter.decide(null, null, null, null, null, null));
        MDC.put((String)this.key, null);
        Assertions.assertEquals((Object)FilterReply.DENY, (Object)this.filter.decide(null, null, null, null, null, null));
        MDC.put((String)this.key, (String)this.value);
        Assertions.assertEquals((Object)FilterReply.ACCEPT, (Object)this.filter.decide(null, null, null, null, null, null));
    }

    @Test
    public void testNoValueOption() {
        this.filter.setValue(null);
        this.filter.start();
        Assertions.assertFalse((boolean)this.filter.isStarted());
        MDC.put((String)this.key, null);
        Assertions.assertEquals((Object)FilterReply.NEUTRAL, (Object)this.filter.decide(null, null, null, null, null, null));
        MDC.put((String)this.key, (String)this.value);
        Assertions.assertEquals((Object)FilterReply.NEUTRAL, (Object)this.filter.decide(null, null, null, null, null, null));
    }

    @Test
    public void testNoMDCKeyOption() {
        this.filter.setMDCKey(null);
        this.filter.start();
        Assertions.assertFalse((boolean)this.filter.isStarted());
        MDC.put((String)this.key, null);
        Assertions.assertEquals((Object)FilterReply.NEUTRAL, (Object)this.filter.decide(null, null, null, null, null, null));
        MDC.put((String)this.key, (String)this.value);
        Assertions.assertEquals((Object)FilterReply.NEUTRAL, (Object)this.filter.decide(null, null, null, null, null, null));
    }
}

