/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.pattern.ConverterTest;
import ch.qos.logback.classic.pattern.ExceptionalConverter2;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.classic.util.LogbackMDCAdapter;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.pattern.FormattingConverter;
import ch.qos.logback.core.pattern.PatternLayoutBase;
import ch.qos.logback.core.pattern.parser.test.AbstractPatternLayoutBaseTest;
import ch.qos.logback.core.spi.PropertyContainer;
import ch.qos.logback.core.spi.ScanException;
import ch.qos.logback.core.testUtil.RandomUtil;
import ch.qos.logback.core.testUtil.StringListAppender;
import ch.qos.logback.core.util.OptionHelper;
import java.time.Instant;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.MDC;
import org.slf4j.spi.MDCAdapter;

public class PatternLayoutTest
extends AbstractPatternLayoutBaseTest<ILoggingEvent> {
    private PatternLayout pl = new PatternLayout();
    private LoggerContext loggerContext = new LoggerContext();
    LogbackMDCAdapter logbackMDCAdapter = new LogbackMDCAdapter();
    Logger logger = this.loggerContext.getLogger(ConverterTest.class);
    Logger root = this.loggerContext.getLogger("ROOT");
    int diff = RandomUtil.getPositiveInt();
    String aMessage = "Some message";
    Exception ex = new Exception("Bogus exception");

    @BeforeEach
    public void setUp() {
        this.loggerContext.setMDCAdapter((MDCAdapter)this.logbackMDCAdapter);
        this.pl.setContext((Context)this.loggerContext);
    }

    protected String getExceptionalConverterClassName() {
        return ExceptionalConverter2.class.getName();
    }

    LoggingEvent makeLoggingEvent(String msg, Exception ex) {
        return new LoggingEvent(FormattingConverter.class.getName(), this.logger, Level.INFO, msg, (Throwable)ex, null);
    }

    public ILoggingEvent getEventObject() {
        return this.makeLoggingEvent("Some message", null);
    }

    public PatternLayoutBase<ILoggingEvent> getPatternLayoutBase() {
        return new PatternLayout();
    }

    @Test
    public void testOK() {
        this.pl.setPattern("%d %le [%t] %lo{30} - %m%n");
        this.pl.start();
        String val = this.pl.doLayout(this.getEventObject());
        String regex = "\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2},\\d{3} INFO \\[([mM]ain|pool-\\d-)([Tt]hread)?(-\\d{1,3})?\\] c.q.l.c.pattern.ConverterTest - Some message\\s*";
        Assertions.assertTrue((boolean)val.matches(regex), (String)("val=" + val));
    }

    @Test
    public void testNoExeptionHandler() {
        this.pl.setPattern("%m%n");
        this.pl.start();
        String val = this.pl.doLayout((ILoggingEvent)this.makeLoggingEvent(this.aMessage, this.ex));
        Assertions.assertTrue((boolean)val.contains("java.lang.Exception: Bogus exception"));
    }

    @Test
    public void testCompositePattern() {
        this.pl.setPattern("%-56(%d %lo{20}) - %m%n");
        this.pl.start();
        String val = this.pl.doLayout(this.getEventObject());
        String regex = "\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2},\\d{3} c.q.l.c.p.ConverterTest          - Some message\\s*";
        Assertions.assertTrue((boolean)val.matches(regex));
    }

    @Test
    public void contextProperty() {
        this.pl.setPattern("%property{a}");
        this.pl.start();
        this.loggerContext.putProperty("a", "b");
        String val = this.pl.doLayout(this.getEventObject());
        Assertions.assertEquals((Object)"b", (Object)val);
    }

    @Test
    public void testNopExeptionHandler() {
        this.pl.setPattern("%nopex %m%n");
        this.pl.start();
        String val = this.pl.doLayout((ILoggingEvent)this.makeLoggingEvent(this.aMessage, this.ex));
        Assertions.assertTrue((!val.contains("java.lang.Exception: Bogus exception") ? 1 : 0) != 0);
    }

    @Test
    public void testWithParenthesis() {
        this.pl.setPattern("\\(%msg:%msg\\) %msg");
        this.pl.start();
        LoggingEvent le = this.makeLoggingEvent(this.aMessage, null);
        String val = this.pl.doLayout((ILoggingEvent)le);
        Assertions.assertEquals((Object)"(Some message:Some message) Some message", (Object)val);
    }

    @Test
    public void testWithLettersComingFromLog4j() {
        this.pl.setPattern("%d %p [%t] %c{30} - %m%n");
        this.pl.start();
        String val = this.pl.doLayout(this.getEventObject());
        String regex = "\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2},\\d{3} INFO \\[([mM]ain|pool-\\d-)([Tt]hread)?(-\\d{1,3})?\\] c.q.l.c.pattern.ConverterTest - Some message\\s*";
        Assertions.assertTrue((boolean)val.matches(regex));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void mdcWithDefaultValue() throws ScanException {
        String pattern = "%msg %mdc{foo1} %mdc{bar:-[null]}";
        this.pl.setPattern(OptionHelper.substVars((String)pattern, (PropertyContainer)this.loggerContext));
        this.pl.start();
        String key = "foo1";
        this.logbackMDCAdapter.put(key, key);
        try {
            String val = this.pl.doLayout(this.getEventObject());
            Assertions.assertEquals((Object)"Some message foo1 [null]", (Object)val);
        }
        finally {
            this.logbackMDCAdapter.remove(key);
        }
    }

    @Test
    public void contextNameTest() {
        this.pl.setPattern("%contextName");
        this.loggerContext.setName("aValue");
        this.pl.start();
        String val = this.pl.doLayout(this.getEventObject());
        Assertions.assertEquals((Object)"aValue", (Object)val);
    }

    @Test
    public void cnTest() {
        this.pl.setPattern("%cn");
        this.loggerContext.setName("aValue");
        this.pl.start();
        String val = this.pl.doLayout(this.getEventObject());
        Assertions.assertEquals((Object)"aValue", (Object)val);
    }

    @Test
    public void micros() {
        this.verifyMicros(122891479, "2011-12-03 10:15:30.122 891 Some message");
        this.verifyMicros(122091479, "2011-12-03 10:15:30.122 091 Some message");
        this.verifyMicros(122001479, "2011-12-03 10:15:30.122 001 Some message");
    }

    void verifyMicros(int nanos, String expected) {
        Instant instant = Instant.parse("2011-12-03T10:15:30Z");
        instant = instant.plusNanos(nanos);
        LoggingEvent le = this.makeLoggingEvent(this.aMessage, null);
        le.setInstant(instant);
        this.pl.setPattern("%date{yyyy-MM-dd HH:mm:ss.SSS, UTC} %micros %message%nopex");
        this.pl.start();
        String val = this.pl.doLayout((ILoggingEvent)le);
        Assertions.assertEquals((Object)expected, (Object)val);
    }

    public Context getContext() {
        return this.loggerContext;
    }

    void configure(String file) throws JoranException {
        JoranConfigurator jc = new JoranConfigurator();
        jc.setContext((Context)this.loggerContext);
        jc.doConfigure(file);
    }

    @Test
    public void testConversionRuleSupportInPatternLayout() throws JoranException {
        this.configure("src/test/input/joran/conversionRule/patternLayout0.xml");
        this.root.getAppender("LIST");
        String msg = "Simon says";
        this.logger.debug(msg);
        StringListAppender sla = (StringListAppender)this.root.getAppender("LIST");
        Assertions.assertNotNull((Object)sla);
        Assertions.assertEquals((int)1, (int)sla.strList.size());
        Assertions.assertEquals((Object)("sample - " + msg), sla.strList.get(0));
    }

    @Test
    public void smokeReplace() {
        this.pl.setPattern("%replace(a1234b){'\\d{4}', 'XXXX'}");
        this.pl.start();
        String val = this.pl.doLayout(this.getEventObject());
        Assertions.assertEquals((Object)"aXXXXb", (Object)val);
    }

    @Test
    public void replaceNewline() throws ScanException {
        String pattern = "%replace(A\nB){'\n', '\n\t'}";
        String substPattern = OptionHelper.substVars((String)pattern, null, (PropertyContainer)this.loggerContext);
        Assertions.assertEquals((Object)pattern, (Object)substPattern);
        this.pl.setPattern(substPattern);
        this.pl.start();
        String val = this.pl.doLayout((ILoggingEvent)this.makeLoggingEvent("", null));
        Assertions.assertEquals((Object)"A\n\tB", (Object)val);
    }

    @Test
    public void replaceWithJoran() throws JoranException {
        this.configure("src/test/input/joran/pattern/replace0.xml");
        this.root.getAppender("LIST");
        String msg = "And the number is 4111111111110000, expiring on 12/2010";
        this.logger.debug(msg);
        StringListAppender sla = (StringListAppender)this.root.getAppender("LIST");
        Assertions.assertNotNull((Object)sla);
        Assertions.assertEquals((int)1, (int)sla.strList.size());
        Assertions.assertEquals((Object)"And the number is XXXX, expiring on 12/2010", sla.strList.get(0));
    }

    @Test
    public void replaceWithJoran_NEWLINE() throws JoranException {
        this.loggerContext.putProperty("TAB", "\t");
        this.configure("src/test/input/joran/pattern/replaceNewline.xml");
        this.root.getAppender("LIST");
        String msg = "A\nC";
        this.logger.debug(msg);
        StringListAppender sla = (StringListAppender)this.root.getAppender("LIST");
        Assertions.assertNotNull((Object)sla);
        Assertions.assertEquals((int)1, (int)sla.strList.size());
        Assertions.assertEquals((Object)"A\n\tC", sla.strList.get(0));
    }

    @Test
    public void prefixConverterSmoke() {
        String pattern = "%prefix(%logger) %message";
        this.pl.setPattern(pattern);
        this.pl.start();
        String val = this.pl.doLayout((ILoggingEvent)this.makeLoggingEvent("hello", null));
        Assertions.assertEquals((Object)("logger=" + this.logger.getName() + " hello"), (Object)val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void prefixConverterWithMDC() {
        String mdcKey = "boo";
        String mdcVal = "moo";
        String pattern = "%prefix(%level %logger %X{" + mdcKey + "}) %message";
        this.pl.setPattern(pattern);
        this.pl.start();
        this.logbackMDCAdapter.put(mdcKey, mdcVal);
        try {
            String val = this.pl.doLayout((ILoggingEvent)this.makeLoggingEvent("hello", null));
            Assertions.assertEquals((Object)("level=INFO logger=" + this.logger.getName() + " " + mdcKey + "=" + mdcVal + " hello"), (Object)val);
        }
        finally {
            MDC.remove((String)mdcKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void prefixConverterWithProperty() {
        try {
            String propertyKey = "px1953";
            String propertyVal = "pxVal";
            System.setProperty(propertyKey, propertyVal);
            String pattern = "%prefix(%logger %property{" + propertyKey + "}) %message";
            this.pl.setPattern(pattern);
            this.pl.start();
            String val = this.pl.doLayout((ILoggingEvent)this.makeLoggingEvent("hello", null));
            Assertions.assertEquals((Object)("logger=" + this.logger.getName() + " " + propertyKey + "=" + propertyVal + " hello"), (Object)val);
        }
        finally {
            System.clearProperty("px");
        }
    }
}

