/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.corpus;

import ch.qos.logback.classic.corpus.CorpusModel;
import ch.qos.logback.classic.corpus.LogStatement;
import ch.qos.logback.classic.corpus.TextFileUtil;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.PubLoggerContextVO;
import ch.qos.logback.classic.spi.PubLoggingEventVO;
import ch.qos.logback.classic.spi.ThrowableProxyUtil;
import ch.qos.logback.core.CoreConstants;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.List;

public class Corpus {
    public static final int STANDARD_CORPUS_SIZE = 50000;
    private static final int STANDARD_SEED = 34780;

    public static List<String> getStandatdCorpusWordList() throws IOException {
        ClassLoader classLoader = Corpus.class.getClassLoader();
        URL originOfSpeciesURL = classLoader.getResource("corpus/origin_of_species.txt");
        return TextFileUtil.toWords(originOfSpeciesURL);
    }

    public static ILoggingEvent[] makeStandardCorpus() throws IOException {
        List<String> worldList = Corpus.getStandatdCorpusWordList();
        CorpusModel corpusMaker = new CorpusModel(34780L, worldList);
        return Corpus.make(corpusMaker, 50000, true);
    }

    public static ILoggingEvent[] make(CorpusModel corpusModel, int n, boolean withCallerData) {
        PubLoggerContextVO lcVO = corpusModel.getRandomlyNamedLoggerContextVO();
        ILoggingEvent[] plevoArray = new PubLoggingEventVO[n];
        for (int i = 0; i < n; ++i) {
            PubLoggingEventVO e = new PubLoggingEventVO();
            plevoArray[i] = e;
            e.loggerContextVO = lcVO;
            e.timeStamp = corpusModel.getRandomTimeStamp();
            LogStatement logStatement = corpusModel.getRandomLogStatementFromPool();
            e.loggerName = logStatement.loggerName;
            e.level = logStatement.level;
            e.message = logStatement.mat.message;
            e.argumentArray = corpusModel.getRandomArgumentArray(logStatement.mat.numberOfArguments);
            if (withCallerData) {
                e.callerDataArray = corpusModel.getRandomCallerData(8, e.loggerName);
            }
            e.throwableProxy = logStatement.throwableProxy;
            e.threadName = corpusModel.getRandomThreadNameFromPool();
        }
        return plevoArray;
    }

    public static void dump(ILoggingEvent[] eventArray, String targetFile) throws IOException {
        FileWriter fw = new FileWriter(targetFile);
        for (ILoggingEvent e : eventArray) {
            fw.write(e.toString());
            fw.append(CoreConstants.LINE_SEPARATOR);
            if (e.getThrowableProxy() == null) continue;
            IThrowableProxy tp = e.getThrowableProxy();
            fw.write(ThrowableProxyUtil.asString((IThrowableProxy)tp));
        }
        fw.flush();
        fw.close();
    }
}

