/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.jsonTest;

import ch.qos.logback.classic.spi.LoggerContextVO;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class LoggerContextVODeserializer
extends StdDeserializer<LoggerContextVO> {
    public LoggerContextVODeserializer() {
        this(null);
    }

    public LoggerContextVODeserializer(Class<?> vc) {
        super(vc);
    }

    public LoggerContextVO deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JacksonException {
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        if (node.isObject()) {
            JsonNode nameNode = node.get("name");
            String name = nameNode.asText();
            JsonNode bdayNode = node.get("birthdate");
            long birthday = bdayNode.asLong();
            JsonNode propertiesNode = node.get("properties");
            HashMap<String, String> propertiesMap = new HashMap<String, String>();
            Iterator it = propertiesNode.fields();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                String key = (String)entry.getKey();
                String value = ((JsonNode)entry.getValue()).asText();
                propertiesMap.put(key, value);
            }
            return new LoggerContextVO(name, propertiesMap, birthday);
        }
        return null;
    }
}

