/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.net.server;

import ch.qos.logback.classic.net.server.InstrumentedServerSocketReceiver;
import ch.qos.logback.classic.net.server.RemoteAppenderClient;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.net.mock.MockContext;
import ch.qos.logback.core.net.server.ServerListener;
import ch.qos.logback.core.net.server.ServerRunner;
import ch.qos.logback.core.net.server.test.MockServerListener;
import ch.qos.logback.core.net.server.test.MockServerRunner;
import ch.qos.logback.core.net.server.test.ServerSocketUtil;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.Status;
import java.io.IOException;
import java.net.ServerSocket;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ServerSocketReceiverTest {
    private MockContext context = new MockContext();
    private MockServerRunner<RemoteAppenderClient> runner = new MockServerRunner();
    private MockServerListener<RemoteAppenderClient> listener = new MockServerListener();
    private ServerSocket serverSocket;
    private InstrumentedServerSocketReceiver receiver;

    @BeforeEach
    public void setUp() throws Exception {
        this.serverSocket = ServerSocketUtil.createServerSocket();
        this.receiver = new InstrumentedServerSocketReceiver(this.serverSocket, (ServerListener<RemoteAppenderClient>)this.listener, (ServerRunner<RemoteAppenderClient>)this.runner);
        this.receiver.setContext((Context)this.context);
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.serverSocket.close();
    }

    @Test
    public void testStartStop() throws Exception {
        this.receiver.start();
        Assertions.assertTrue((boolean)this.runner.isContextInjected());
        Assertions.assertTrue((boolean)this.runner.isRunning());
        Assertions.assertSame(this.listener, (Object)this.receiver.getLastListener());
        this.receiver.stop();
        Assertions.assertFalse((boolean)this.runner.isRunning());
    }

    @Test
    public void testStartWhenAlreadyStarted() throws Exception {
        this.receiver.start();
        this.receiver.start();
        Assertions.assertEquals((int)1, (int)this.runner.getStartCount());
    }

    @Test
    public void testStopThrowsException() throws Exception {
        this.receiver.start();
        Assertions.assertTrue((boolean)this.receiver.isStarted());
        IOException ex = new IOException("test exception");
        this.runner.setStopException(ex);
        this.receiver.stop();
        Status status = this.context.getLastStatus();
        Assertions.assertNotNull((Object)status);
        Assertions.assertTrue((boolean)(status instanceof ErrorStatus));
        Assertions.assertTrue((boolean)status.getMessage().contains(ex.getMessage()));
        Assertions.assertSame((Object)ex, (Object)status.getThrowable());
    }

    @Test
    public void testStopWhenNotStarted() throws Exception {
        this.receiver.stop();
        Assertions.assertEquals((int)0, (int)this.runner.getStartCount());
    }
}

