/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.spi;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.BasicContextListener;
import ch.qos.logback.classic.spi.LoggerContextListener;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ContextListenerTest {
    LoggerContext context;
    BasicContextListener listener;

    @BeforeEach
    public void setUp() throws Exception {
        this.context = new LoggerContext();
        this.listener = new BasicContextListener();
        this.context.addListener((LoggerContextListener)this.listener);
    }

    @Test
    public void testNotifyOnReset() {
        this.context.reset();
        Assertions.assertEquals((Object)((Object)BasicContextListener.UpdateType.RESET), (Object)((Object)this.listener.updateType));
        Assertions.assertEquals((Object)this.listener.context, (Object)this.context);
    }

    @Test
    public void testNotifyOnStopResistant() {
        this.listener.setResetResistant(true);
        this.context.stop();
        Assertions.assertEquals((Object)((Object)BasicContextListener.UpdateType.STOP), (Object)((Object)this.listener.updateType));
        Assertions.assertEquals((Object)this.listener.context, (Object)this.context);
    }

    @Test
    public void testNotifyOnStopNotResistant() {
        this.context.stop();
        Assertions.assertEquals((Object)((Object)BasicContextListener.UpdateType.RESET), (Object)((Object)this.listener.updateType));
        Assertions.assertEquals((Object)this.listener.context, (Object)this.context);
    }

    @Test
    public void testNotifyOnStart() {
        this.context.start();
        Assertions.assertEquals((Object)((Object)BasicContextListener.UpdateType.START), (Object)((Object)this.listener.updateType));
        Assertions.assertEquals((Object)this.listener.context, (Object)this.context);
    }

    void checkLevelChange(String loggerName, Level level) {
        Logger logger = this.context.getLogger(loggerName);
        logger.setLevel(level);
        Assertions.assertEquals((Object)((Object)BasicContextListener.UpdateType.LEVEL_CHANGE), (Object)((Object)this.listener.updateType));
        Assertions.assertEquals((Object)this.listener.logger, (Object)logger);
        Assertions.assertEquals((Object)this.listener.level, (Object)level);
    }

    @Test
    public void testLevelChange() {
        this.checkLevelChange("a", Level.INFO);
        this.checkLevelChange("a.b", Level.ERROR);
        this.checkLevelChange("a.b.c", Level.DEBUG);
    }
}

