/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.util.Duration;
import java.util.Arrays;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Logback1551 {
    LoggerContext lc;

    @BeforeEach
    public void setUp() throws Exception {
        this.lc = new LoggerContext();
        this.lc.setName("x");
    }

    @Test
    public void testConcurrentModificationScheduledTasks() {
        ScheduledExecutorService scheduledExecutorService = this.lc.getScheduledExecutorService();
        Duration duration = Duration.buildByMilliseconds((double)10.0);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        ScheduledFuture<?> scheduledFuture = scheduledExecutorService.scheduleAtFixedRate(runnable, duration.getMilliseconds(), duration.getMilliseconds(), TimeUnit.MILLISECONDS);
        this.lc.addScheduledFuture(scheduledFuture);
        int THREAD_COUNT = 20;
        Thread[] threads = new Thread[THREAD_COUNT];
        for (int i = 0; i < THREAD_COUNT; ++i) {
            threads[i] = new Thread(new CancelRunnable(this.lc));
            threads[i].start();
        }
        Arrays.stream(threads).forEach(t -> {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private class CancelRunnable
    implements Runnable {
        LoggerContext lc;

        public CancelRunnable(LoggerContext lc) {
            this.lc = lc;
        }

        @Override
        public void run() {
            this.lc.cancelScheduledTasks();
        }
    }
}

