/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.LoggerTestHelper;
import ch.qos.logback.classic.turbo.NOPTurboFilter;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.core.status.StatusManager;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class LoggerContextTest {
    LoggerContext lc;

    @BeforeEach
    public void setUp() throws Exception {
        this.lc = new LoggerContext();
        this.lc.setName("x");
    }

    @Test
    public void testRootGetLogger() {
        Logger root = this.lc.getLogger("ROOT");
        Assertions.assertEquals((Object)Level.DEBUG, (Object)root.getLevel());
        Assertions.assertEquals((Object)Level.DEBUG, (Object)root.getEffectiveLevel());
    }

    @Test
    public void testLoggerX() {
        Logger x = this.lc.getLogger("x");
        Assertions.assertNotNull((Object)x);
        Assertions.assertEquals((Object)"x", (Object)x.getName());
        Assertions.assertNull((Object)x.getLevel());
        Assertions.assertEquals((Object)Level.DEBUG, (Object)x.getEffectiveLevel());
    }

    @Test
    public void testNull() {
        try {
            this.lc.getLogger((String)null);
            Assertions.fail((String)"null should cause an exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testEmpty() {
        Logger empty = this.lc.getLogger("");
        LoggerTestHelper.assertNameEquals(empty, "");
        LoggerTestHelper.assertLevels(null, empty, Level.DEBUG);
        Logger dot = this.lc.getLogger(".");
        LoggerTestHelper.assertNameEquals(dot, ".");
        LoggerTestHelper.assertLevels(null, dot, Level.DEBUG);
        Assertions.assertEquals((int)3, (int)this.lc.getLoggerList().size());
    }

    @Test
    public void testDotDot() {
        Logger dotdot = this.lc.getLogger("..");
        Assertions.assertEquals((int)4, (int)this.lc.getLoggerList().size());
        LoggerTestHelper.assertNameEquals(dotdot, "..");
    }

    int instanceCount() {
        return this.lc.getLoggerList().size();
    }

    @Test
    public void testLoggerXY() {
        Assertions.assertEquals((int)1, (int)this.lc.getLoggerList().size());
        Logger xy = this.lc.getLogger("x.y");
        Assertions.assertEquals((int)3, (int)this.instanceCount());
        LoggerTestHelper.assertNameEquals(xy, "x.y");
        LoggerTestHelper.assertLevels(null, xy, Level.DEBUG);
        Logger x = this.lc.getLogger("x");
        Assertions.assertEquals((int)3, (int)this.instanceCount());
        Logger xy2 = this.lc.getLogger("x.y");
        Assertions.assertEquals((Object)xy, (Object)xy2);
        Logger x2 = this.lc.getLogger("x");
        Assertions.assertEquals((Object)x, (Object)x2);
        Assertions.assertEquals((int)3, (int)this.instanceCount());
    }

    @Test
    public void testLoggerMultipleChildren() {
        Assertions.assertEquals((int)1, (int)this.instanceCount());
        Logger xy0 = this.lc.getLogger("x.y0");
        LoggerTestHelper.assertNameEquals(xy0, "x.y0");
        Logger xy1 = this.lc.getLogger("x.y1");
        LoggerTestHelper.assertNameEquals(xy1, "x.y1");
        LoggerTestHelper.assertLevels(null, xy0, Level.DEBUG);
        LoggerTestHelper.assertLevels(null, xy1, Level.DEBUG);
        Assertions.assertEquals((int)4, (int)this.instanceCount());
        for (int i = 0; i < 100; ++i) {
            Logger xy_i = this.lc.getLogger("x.y" + i);
            LoggerTestHelper.assertNameEquals(xy_i, "x.y" + i);
            LoggerTestHelper.assertLevels(null, xy_i, Level.DEBUG);
        }
        Assertions.assertEquals((int)102, (int)this.instanceCount());
    }

    @Test
    public void testMultiLevel() {
        Logger wxyz = this.lc.getLogger("w.x.y.z");
        LoggerTestHelper.assertNameEquals(wxyz, "w.x.y.z");
        LoggerTestHelper.assertLevels(null, wxyz, Level.DEBUG);
        Logger wx = this.lc.getLogger("w.x");
        wx.setLevel(Level.INFO);
        LoggerTestHelper.assertNameEquals(wx, "w.x");
        LoggerTestHelper.assertLevels(Level.INFO, wx, Level.INFO);
        LoggerTestHelper.assertLevels(null, this.lc.getLogger("w.x.y"), Level.INFO);
        LoggerTestHelper.assertLevels(null, wxyz, Level.INFO);
    }

    @Test
    public void testStatusWithUnconfiguredContext() {
        int i;
        Logger logger = this.lc.getLogger(LoggerContextTest.class);
        for (i = 0; i < 3; ++i) {
            logger.debug("test");
        }
        logger = this.lc.getLogger("x.y.z");
        for (i = 0; i < 3; ++i) {
            logger.debug("test");
        }
        StatusManager sm = this.lc.getStatusManager();
        Assertions.assertTrue((sm.getCount() == 1 ? 1 : 0) != 0, (String)"StatusManager has recieved too many messages");
    }

    @Test
    public void resetTest() {
        Logger root = this.lc.getLogger("ROOT");
        Logger a = this.lc.getLogger("a");
        Logger ab = this.lc.getLogger("a.b");
        ab.setLevel(Level.WARN);
        root.setLevel(Level.INFO);
        this.lc.reset();
        Assertions.assertEquals((Object)Level.DEBUG, (Object)root.getEffectiveLevel());
        Assertions.assertTrue((boolean)root.isDebugEnabled());
        Assertions.assertEquals((Object)Level.DEBUG, (Object)a.getEffectiveLevel());
        Assertions.assertEquals((Object)Level.DEBUG, (Object)ab.getEffectiveLevel());
        Assertions.assertEquals((Object)Level.DEBUG, (Object)root.getLevel());
        Assertions.assertNull((Object)a.getLevel());
        Assertions.assertNull((Object)ab.getLevel());
    }

    @Test
    public void turboFilterStopOnReset() {
        NOPTurboFilter nopTF = new NOPTurboFilter();
        nopTF.start();
        this.lc.addTurboFilter((TurboFilter)nopTF);
        Assertions.assertTrue((boolean)nopTF.isStarted());
        this.lc.reset();
        Assertions.assertFalse((boolean)nopTF.isStarted());
    }

    @Test
    public void resetTest_LBCORE_104() {
        this.lc.putProperty("keyA", "valA");
        this.lc.putObject("keyA", (Object)"valA");
        Assertions.assertEquals((Object)"valA", (Object)this.lc.getProperty("keyA"));
        Assertions.assertEquals((Object)"valA", (Object)this.lc.getObject("keyA"));
        this.lc.reset();
        Assertions.assertNull((Object)this.lc.getProperty("keyA"));
        Assertions.assertNull((Object)this.lc.getObject("keyA"));
    }

    @Test
    public void loggerNameEndingInDotOrDollarShouldWork() {
        String loggerName = "toto.x.";
        Logger logger = this.lc.getLogger(loggerName);
        Assertions.assertEquals((Object)loggerName, (Object)logger.getName());
        loggerName = "toto.x$";
        logger = this.lc.getLogger(loggerName);
        Assertions.assertEquals((Object)loggerName, (Object)logger.getName());
    }

    @Test
    public void levelResetTest() {
        Logger root = this.lc.getLogger("ROOT");
        root.setLevel(Level.TRACE);
        Assertions.assertTrue((boolean)root.isTraceEnabled());
        this.lc.reset();
        Assertions.assertFalse((boolean)root.isTraceEnabled());
        Assertions.assertTrue((boolean)root.isDebugEnabled());
    }

    @Test
    public void evaluatorMapPostReset() {
        this.lc.reset();
        Assertions.assertNotNull((Object)this.lc.getObject("EVALUATOR_MAP"));
    }

    @Test
    public void collisionMapsPostReset() {
        this.lc.reset();
        Map fileCollisions = (Map)this.lc.getObject("FA_FILENAMES_MAP");
        Assertions.assertNotNull((Object)fileCollisions);
        Assertions.assertTrue((boolean)fileCollisions.isEmpty());
        Map filenamePatternCollisionMap = (Map)this.lc.getObject("RFA_FILENAME_PATTERN_COLLISION_MAP");
        Assertions.assertNotNull((Object)filenamePatternCollisionMap);
        Assertions.assertTrue((boolean)filenamePatternCollisionMap.isEmpty());
    }

    @Test
    public void concurrentModification() {
        int runLen = 100;
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < 100; ++i) {
                    LoggerContextTest.this.lc.getLogger("a" + i);
                    Thread.yield();
                }
            }
        });
        thread.start();
        for (int i = 0; i < 100; ++i) {
            this.lc.putProperty("a" + i, "val");
            Thread.yield();
        }
    }
}

