/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.NoFilter;
import ch.qos.logback.classic.YesFilter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.turbo.MDCFilter;
import ch.qos.logback.classic.turbo.MarkerFilter;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.core.read.ListAppender;
import ch.qos.logback.core.testUtil.RandomUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.MDC;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class TurboFilteringInLoggerTest {
    static final String BLUE = "BLUE";
    LoggerContext loggerContext;
    Logger logger;
    Marker blueMarker = MarkerFactory.getMarker((String)"BLUE");
    int diff = RandomUtil.getPositiveInt();
    String key = "tfiolKey" + this.diff;
    String value = "val" + this.diff;
    ListAppender<ILoggingEvent> listAppender = new ListAppender();
    MDCFilter mdcFilter = new MDCFilter();

    @BeforeEach
    public void setUp() throws Exception {
        this.loggerContext = new LoggerContext();
        this.loggerContext.setName("test");
        this.loggerContext.start();
        this.logger = this.loggerContext.getLogger(TurboFilteringInLoggerTest.class);
        Logger root = this.loggerContext.getLogger("ROOT");
        root.setLevel(Level.ERROR);
        this.listAppender.start();
        root.addAppender(this.listAppender);
    }

    private void addMDCFilter() {
        this.mdcFilter.setOnMatch("ACCEPT");
        this.mdcFilter.setOnMismatch("DENY");
        this.mdcFilter.setMDCKey(this.key);
        this.mdcFilter.setValue(this.value);
        this.mdcFilter.start();
        this.loggerContext.addTurboFilter((TurboFilter)this.mdcFilter);
    }

    private void addYesFilter() {
        YesFilter filter = new YesFilter();
        filter.start();
        this.loggerContext.addTurboFilter((TurboFilter)filter);
    }

    private void addNoFilter() {
        NoFilter filter = new NoFilter();
        filter.start();
        this.loggerContext.addTurboFilter((TurboFilter)filter);
    }

    private void addAcceptBLUEFilter() {
        MarkerFilter filter = new MarkerFilter();
        filter.setMarker(BLUE);
        filter.setOnMatch("ACCEPT");
        filter.start();
        this.loggerContext.addTurboFilter((TurboFilter)filter);
    }

    private void addDenyBLUEFilter() {
        MarkerFilter filter = new MarkerFilter();
        filter.setMarker(BLUE);
        filter.setOnMatch("DENY");
        filter.start();
        this.loggerContext.addTurboFilter((TurboFilter)filter);
    }

    @Test
    public void testIsDebugEnabledWithYesFilter() {
        this.addYesFilter();
        this.logger.setLevel(Level.INFO);
        Assertions.assertTrue((boolean)this.logger.isDebugEnabled());
    }

    @Test
    public void testIsInfoEnabledWithYesFilter() {
        this.addYesFilter();
        this.logger.setLevel(Level.WARN);
        Assertions.assertTrue((boolean)this.logger.isInfoEnabled());
    }

    @Test
    public void testIsWarnEnabledWithYesFilter() {
        this.addYesFilter();
        this.logger.setLevel(Level.ERROR);
        Assertions.assertTrue((boolean)this.logger.isWarnEnabled());
    }

    @Test
    public void testIsErrorEnabledWithYesFilter() {
        this.addYesFilter();
        this.logger.setLevel(Level.OFF);
        Assertions.assertTrue((boolean)this.logger.isErrorEnabled());
    }

    @Test
    public void testIsEnabledForWithYesFilter() {
        this.addYesFilter();
        this.logger.setLevel(Level.ERROR);
        Assertions.assertTrue((boolean)this.logger.isEnabledFor(Level.INFO));
    }

    @Test
    public void testIsEnabledForWithNoFilter() {
        this.addNoFilter();
        this.logger.setLevel(Level.DEBUG);
        Assertions.assertFalse((boolean)this.logger.isEnabledFor(Level.INFO));
    }

    @Test
    public void testIsDebugEnabledWithNoFilter() {
        this.addNoFilter();
        this.logger.setLevel(Level.DEBUG);
        Assertions.assertFalse((boolean)this.logger.isDebugEnabled());
    }

    @Test
    public void testIsInfoEnabledWithNoFilter() {
        this.addNoFilter();
        this.logger.setLevel(Level.DEBUG);
        Assertions.assertFalse((boolean)this.logger.isInfoEnabled());
    }

    @Test
    public void testIsWarnEnabledWithNoFilter() {
        this.addNoFilter();
        this.logger.setLevel(Level.DEBUG);
        Assertions.assertFalse((boolean)this.logger.isWarnEnabled());
    }

    @Test
    public void testIsErrorEnabledWithNoFilter() {
        this.addNoFilter();
        this.logger.setLevel(Level.DEBUG);
        Assertions.assertFalse((boolean)this.logger.isErrorEnabled());
    }

    @Test
    public void testIsErrorEnabledWithAcceptBlueFilter() {
        this.addAcceptBLUEFilter();
        this.logger.setLevel(Level.ERROR);
        Assertions.assertTrue((boolean)this.logger.isDebugEnabled(this.blueMarker));
    }

    @Test
    public void testIsErrorEnabledWithDenyBlueFilter() {
        this.addDenyBLUEFilter();
        this.logger.setLevel(Level.ALL);
        Assertions.assertFalse((boolean)this.logger.isDebugEnabled(this.blueMarker));
    }

    @Test
    public void testLoggingContextReset() {
        this.addYesFilter();
        Assertions.assertNotNull((Object)this.loggerContext.getTurboFilterList().get(0));
        this.loggerContext.reset();
        Assertions.assertEquals((int)0, (int)this.loggerContext.getTurboFilterList().size());
    }

    @Test
    public void fluentAPI() {
        this.addMDCFilter();
        Logger logger = this.loggerContext.getLogger(this.getClass());
        logger.atDebug().log("hello 1");
        Assertions.assertEquals((int)0, (int)this.listAppender.list.size());
        MDC.put((String)this.key, (String)this.value);
        logger.atDebug().log("hello 2");
        Assertions.assertEquals((int)1, (int)this.listAppender.list.size());
    }
}

