/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.issue.logback_1754;

import ch.qos.logback.core.testUtil.RandomUtil;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SafeModeTest {
    private static final int THREADS = 3;

    private void runTest() {
        int i;
        CountDownLatch latch = new CountDownLatch(3);
        ArrayList<LoggerThread> threads = new ArrayList<LoggerThread>(3);
        for (i = 0; i < 3; ++i) {
            LoggerThread thread = new LoggerThread(latch, "message from thread " + i);
            thread.start();
            threads.add(thread);
        }
        i = 0;
        for (Thread thread : threads) {
            try {
                thread.join();
                System.out.println("joined thread " + thread.getName());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String ... args) {
        int diff = RandomUtil.getPositiveInt();
        System.setProperty("logback.configurationFile", "src/test/input/issue/logback-1754.xml");
        System.setProperty("logback_1754_targetDirectory", "target/test-output/safeWrite_" + diff);
        new SafeModeTest().runTest();
    }

    private static final class LoggerThread
    extends Thread {
        private static final Logger LOG = LoggerFactory.getLogger(LoggerThread.class);
        private final CountDownLatch latch;
        private final String message;

        LoggerThread(CountDownLatch latch, String message) {
            this.setDaemon(false);
            this.latch = latch;
            this.message = message;
        }

        @Override
        public void run() {
            this.latch.countDown();
            for (int i = 0; i < 100; ++i) {
                if (i % 10 == 0) {
                    LoggerThread.delay(1L);
                }
                LOG.info(this.message + " i=" + i);
            }
        }

        static void delay(long millis) {
            try {
                Thread.sleep(millis);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

