/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.jsonTest;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.jsonTest.JsonLoggingEvent;
import ch.qos.logback.classic.jsonTest.KeyValuePairDeserializer;
import ch.qos.logback.classic.jsonTest.LevelDeserializer;
import ch.qos.logback.classic.jsonTest.LoggerContextVODeserializer;
import ch.qos.logback.classic.jsonTest.MarkerDeserializer;
import ch.qos.logback.classic.jsonTest.PubThrowableProxyDeserializer;
import ch.qos.logback.classic.jsonTest.STEPDeserializer;
import ch.qos.logback.classic.spi.LoggerContextVO;
import ch.qos.logback.classic.spi.PubThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.IMarkerFactory;
import org.slf4j.Marker;
import org.slf4j.event.KeyValuePair;

public class JsonStringToLoggingEventMapper {
    IMarkerFactory markerFactory;

    public JsonStringToLoggingEventMapper(IMarkerFactory markerFactory) {
        this.markerFactory = markerFactory;
    }

    public JsonLoggingEvent mapStringToLoggingEvent(String resultString) throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        SimpleModule module = new SimpleModule();
        module.addDeserializer(StackTraceElementProxy.class, (JsonDeserializer)new STEPDeserializer());
        module.addDeserializer(Level.class, (JsonDeserializer)new LevelDeserializer());
        module.addDeserializer(Marker.class, (JsonDeserializer)new MarkerDeserializer(this.markerFactory));
        module.addDeserializer(KeyValuePair.class, (JsonDeserializer)new KeyValuePairDeserializer());
        module.addDeserializer(LoggerContextVO.class, (JsonDeserializer)new LoggerContextVODeserializer());
        module.addDeserializer(PubThrowableProxy.class, (JsonDeserializer)new PubThrowableProxyDeserializer());
        objectMapper.registerModule((Module)module);
        JsonNode jsonNode = objectMapper.readTree(resultString);
        JsonLoggingEvent resultEvent = (JsonLoggingEvent)objectMapper.treeToValue((TreeNode)jsonNode, JsonLoggingEvent.class);
        return resultEvent;
    }

    private static void UNUSED_buildLevel(JsonNode jsonNode, JsonLoggingEvent resultEvent) {
        Level level;
        String levelStr = jsonNode.at("/level").asText();
        resultEvent.level = level = Level.toLevel((String)levelStr);
    }

    private void UNUSED_buildMarkersList(JsonNode jsonNode, JsonLoggingEvent resultEvent) {
        JsonNode markersNode = jsonNode.at("/markers");
        if (markersNode != null && markersNode.isArray()) {
            ArrayList<Marker> markerList = new ArrayList<Marker>();
            for (JsonNode item : markersNode) {
                String markerStr = item.asText();
                Marker marker = this.markerFactory.getMarker(markerStr);
                markerList.add(marker);
            }
            resultEvent.markerList = markerList;
        }
    }

    private void UNUSED_buildKVPList(JsonNode jsonNode, JsonLoggingEvent resultEvent) {
        JsonNode kvpNode = jsonNode.at("/kvpList");
        if (kvpNode != null && kvpNode.isArray()) {
            System.out.println("in buildKVPList");
            ArrayList<KeyValuePair> kvpList = new ArrayList<KeyValuePair>();
            for (JsonNode item : kvpNode) {
                Map.Entry entry = (Map.Entry)item.fields().next();
                String key = (String)entry.getKey();
                String val = ((JsonNode)entry.getValue()).asText();
                kvpList.add(new KeyValuePair(key, (Object)val));
            }
            resultEvent.kvpList = kvpList;
        }
    }
}

