/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.pattern.CallerDataConverter;
import ch.qos.logback.classic.pattern.ClassOfCallerConverter;
import ch.qos.logback.classic.pattern.ContextNameConverter;
import ch.qos.logback.classic.pattern.DateConverter;
import ch.qos.logback.classic.pattern.FileOfCallerConverter;
import ch.qos.logback.classic.pattern.LevelConverter;
import ch.qos.logback.classic.pattern.LineOfCallerConverter;
import ch.qos.logback.classic.pattern.LineSeparatorConverter;
import ch.qos.logback.classic.pattern.LoggerConverter;
import ch.qos.logback.classic.pattern.MDCConverter;
import ch.qos.logback.classic.pattern.MessageConverter;
import ch.qos.logback.classic.pattern.MethodOfCallerConverter;
import ch.qos.logback.classic.pattern.PropertyConverter;
import ch.qos.logback.classic.pattern.RelativeTimeConverter;
import ch.qos.logback.classic.pattern.SequenceNumberConverter;
import ch.qos.logback.classic.pattern.SyslogStartConverter;
import ch.qos.logback.classic.pattern.ThreadConverter;
import ch.qos.logback.classic.pattern.ThrowableProxyConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.classic.util.LogbackMDCAdapter;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.pattern.FormatInfo;
import ch.qos.logback.core.pattern.FormattingConverter;
import ch.qos.logback.core.util.EnvUtil;
import ch.qos.logback.core.util.StatusPrinter;
import java.time.Instant;
import java.util.List;
import java.util.regex.Pattern;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.MarkerFactory;
import org.slf4j.spi.MDCAdapter;

public class ConverterTest {
    LoggerContext loggerContext = new LoggerContext();
    LogbackMDCAdapter logbackMDCAdapter = new LogbackMDCAdapter();
    Logger logger = this.loggerContext.getLogger(ConverterTest.class);
    LoggingEvent le;

    LoggingEvent makeLoggingEvent(Exception ex) {
        return new LoggingEvent(FormattingConverter.class.getName(), this.logger, Level.INFO, "Some message", (Throwable)ex, null);
    }

    Exception getException(String msg, Exception cause) {
        return new Exception(msg, cause);
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.loggerContext.setMDCAdapter((MDCAdapter)this.logbackMDCAdapter);
        Exception rootEx = this.getException("Innermost", null);
        Exception nestedEx = this.getException("Nested", rootEx);
        Exception ex = new Exception("Bogus exception", nestedEx);
        this.le = this.makeLoggingEvent(ex);
    }

    @Test
    public void testLineOfCaller() {
        LineOfCallerConverter converter = new LineOfCallerConverter();
        StringBuilder buf = new StringBuilder();
        converter.write(buf, (Object)this.le);
        Assertions.assertEquals((Object)"73", (Object)buf.toString());
    }

    @Test
    public void testLevel() {
        LevelConverter converter = new LevelConverter();
        StringBuilder buf = new StringBuilder();
        converter.write(buf, (Object)this.le);
        Assertions.assertEquals((Object)"INFO", (Object)buf.toString());
        converter = new LevelConverter();
        converter.setFormattingInfo(new FormatInfo(1, 1, true, false));
        buf = new StringBuilder();
        converter.write(buf, (Object)this.le);
        Assertions.assertEquals((Object)"I", (Object)buf.toString());
    }

    @Test
    public void testThread() {
        ThreadConverter converter = new ThreadConverter();
        StringBuilder buf = new StringBuilder();
        converter.write(buf, (Object)this.le);
        System.out.println(buf.toString());
        String regex = "([mM]ain|pool-\\d-)([Tt]hread)?(-\\d{1,3})?";
        Assertions.assertTrue((boolean)buf.toString().matches(regex));
    }

    @Test
    public void testMessage() {
        MessageConverter converter = new MessageConverter();
        StringBuilder buf = new StringBuilder();
        converter.write(buf, (Object)this.le);
        Assertions.assertEquals((Object)"Some message", (Object)buf.toString());
    }

    @Test
    public void testLineSeparator() {
        LineSeparatorConverter converter = new LineSeparatorConverter();
        StringBuilder buf = new StringBuilder();
        converter.write(buf, (Object)this.le);
        Assertions.assertEquals((Object)CoreConstants.LINE_SEPARATOR, (Object)buf.toString());
    }

    @Test
    public void testException() {
        ThrowableProxyConverter converter = new ThrowableProxyConverter();
        StringBuilder buf = new StringBuilder();
        converter.write(buf, (Object)this.le);
        converter = new ThrowableProxyConverter();
        converter.setOptionList(List.of("3"));
        buf = new StringBuilder();
        converter.write(buf, (Object)this.le);
    }

    @Test
    public void testLogger() {
        LoggerConverter converter = new LoggerConverter();
        StringBuilder buf = new StringBuilder();
        converter.write(buf, (Object)this.le);
        Assertions.assertEquals((Object)this.getClass().getName(), (Object)buf.toString());
        converter = new LoggerConverter();
        converter.setOptionList(List.of("20"));
        converter.start();
        buf = new StringBuilder();
        converter.write(buf, (Object)this.le);
        Assertions.assertEquals((Object)"c.q.l.c.p.ConverterTest", (Object)buf.toString());
        converter = new LoggerConverter();
        converter.setOptionList(List.of("0"));
        converter.start();
        buf = new StringBuilder();
        converter.write(buf, (Object)this.le);
        Assertions.assertEquals((Object)"ConverterTest", (Object)buf.toString());
    }

    @Test
    public void testVeryLongLoggerName() {
        LoggerConverter converter = new LoggerConverter();
        converter.setOptionList(List.of("5"));
        converter.start();
        StringBuilder buf = new StringBuilder();
        char c = 'a';
        int extraParts = 3;
        int totalParts = 16 + extraParts;
        StringBuilder loggerNameBuf = new StringBuilder();
        StringBuilder witness = new StringBuilder();
        for (int i = 0; i < totalParts; ++i) {
            loggerNameBuf.append(c).append(c).append(c);
            witness.append(c);
            loggerNameBuf.append('.');
            witness.append('.');
        }
        loggerNameBuf.append("zzzzzz");
        witness.append("zzzzzz");
        this.le.setLoggerName(loggerNameBuf.toString());
        converter.write(buf, (Object)this.le);
        Assertions.assertEquals((Object)witness.toString(), (Object)buf.toString());
    }

    @Test
    public void testClass() {
        ClassOfCallerConverter converter = new ClassOfCallerConverter();
        StringBuilder buf = new StringBuilder();
        converter.write(buf, (Object)this.le);
        Assertions.assertEquals((Object)this.getClass().getName(), (Object)buf.toString());
    }

    @Test
    public void testMethodOfCaller() {
        MethodOfCallerConverter converter = new MethodOfCallerConverter();
        StringBuilder buf = new StringBuilder();
        converter.write(buf, (Object)this.le);
        Assertions.assertEquals((Object)"testMethodOfCaller", (Object)buf.toString());
    }

    @Test
    public void testFileOfCaller() {
        FileOfCallerConverter converter = new FileOfCallerConverter();
        StringBuilder buf = new StringBuilder();
        converter.write(buf, (Object)this.le);
        Assertions.assertEquals((Object)"ConverterTest.java", (Object)buf.toString());
    }

    @Test
    public void testCallerData() {
        CallerDataConverter converter = new CallerDataConverter();
        converter.start();
        StringBuilder buf = new StringBuilder();
        converter.write(buf, (Object)this.le);
        if (buf.length() < 10) {
            Assertions.fail((String)"buf is too short");
        }
        converter = new CallerDataConverter();
        converter.setOptionList(List.of("2", "XXX"));
        converter.start();
        buf = new StringBuilder();
        LoggingEvent event = this.makeLoggingEvent(null);
        event.addMarker(MarkerFactory.getMarker((String)"XXX"));
        converter.write(buf, (Object)event);
        if (buf.length() < 10) {
            Assertions.fail((String)"buf is too short");
        }
        converter = new CallerDataConverter();
        converter.setOptionList(List.of("2", "XXX", "*"));
        converter.start();
        buf = new StringBuilder();
        event = this.makeLoggingEvent(null);
        event.addMarker(MarkerFactory.getMarker((String)"YYY"));
        converter.write(buf, (Object)event);
        if (buf.length() < 10) {
            Assertions.fail((String)"buf is too short");
        }
        converter = new CallerDataConverter();
        converter.setOptionList(List.of("2", "XXX", "*"));
        converter.start();
        buf = new StringBuilder();
        event = this.makeLoggingEvent(null);
        event.addMarker(MarkerFactory.getMarker((String)"YYY"));
        converter.write(buf, (Object)event);
        if (buf.length() < 10) {
            Assertions.fail((String)"buf is too short");
        }
        converter = new CallerDataConverter();
        converter.setOptionList(List.of("2", "XXX", "*"));
        converter.start();
        buf = new StringBuilder();
        converter.write(buf, (Object)this.le);
        if (buf.length() < 10) {
            Assertions.fail((String)"buf is too short");
        }
        converter = new CallerDataConverter();
        boolean jdk18 = EnvUtil.isJDK18OrHigher();
        converter.setOptionList(jdk18 ? List.of("2..3") : List.of("4..5"));
        converter.start();
        StringBuilder buf2 = new StringBuilder();
        converter.write(buf2, (Object)this.le);
        Assertions.assertTrue((buf2.length() >= 10 ? 1 : 0) != 0, (String)"buf is too short");
        Object expectedRegex = "Caller\\+4";
        if (jdk18) {
            expectedRegex = "Caller\\+2";
        }
        expectedRegex = (String)expectedRegex + "\t at (java.base\\/)?java.lang.reflect.Method.invoke.*$";
        String actual = buf2.toString();
        Assertions.assertTrue((boolean)Pattern.compile((String)expectedRegex).matcher(actual).find(), (String)("actual: " + actual));
    }

    @Test
    public void testRelativeTime() throws Exception {
        RelativeTimeConverter converter = new RelativeTimeConverter();
        StringBuilder buf0 = new StringBuilder();
        StringBuilder buf1 = new StringBuilder();
        long timestamp = System.currentTimeMillis();
        LoggingEvent e0 = this.makeLoggingEvent(null);
        e0.setTimeStamp(timestamp);
        LoggingEvent e1 = this.makeLoggingEvent(null);
        e1.setTimeStamp(timestamp);
        converter.write(buf0, (Object)e0);
        converter.write(buf1, (Object)e1);
        Assertions.assertEquals((Object)buf0.toString(), (Object)buf1.toString());
    }

    @Test
    public void testSyslogStart() throws Exception {
        SyslogStartConverter converter = new SyslogStartConverter();
        converter.setOptionList(List.of("MAIL"));
        converter.start();
        LoggingEvent event = this.makeLoggingEvent(null);
        StringBuilder buf = new StringBuilder();
        converter.write(buf, (Object)event);
        String expected = "<22>";
        Assertions.assertTrue((boolean)buf.toString().startsWith(expected));
    }

    @Test
    public void testMDCConverter() throws Exception {
        this.logbackMDCAdapter.clear();
        this.logbackMDCAdapter.put("someKey", "someValue");
        MDCConverter converter = new MDCConverter();
        converter.setOptionList(List.of("someKey"));
        converter.start();
        LoggingEvent event = this.makeLoggingEvent(null);
        String result = converter.convert((ILoggingEvent)event);
        Assertions.assertEquals((Object)"someValue", (Object)result);
    }

    @Test
    public void contextNameConverter() {
        ContextNameConverter converter = new ContextNameConverter();
        LoggerContext lcOther = new LoggerContext();
        lcOther.setName("another");
        converter.setContext((Context)lcOther);
        this.loggerContext.setName("aValue");
        LoggingEvent event = this.makeLoggingEvent(null);
        String result = converter.convert((Object)event);
        Assertions.assertEquals((Object)"aValue", (Object)result);
    }

    @Test
    public void contextProperty() {
        PropertyConverter converter = new PropertyConverter();
        converter.setContext((Context)this.loggerContext);
        converter.setOptionList(List.of("k"));
        converter.start();
        this.loggerContext.setName("aValue");
        this.loggerContext.putProperty("k", "v");
        LoggingEvent event = this.makeLoggingEvent(null);
        String result = converter.convert((ILoggingEvent)event);
        Assertions.assertEquals((Object)"v", (Object)result);
    }

    @Test
    public void testSequenceNumber() {
        SequenceNumberConverter converter = new SequenceNumberConverter();
        converter.setContext((Context)this.loggerContext);
        converter.start();
        Assertions.assertTrue((boolean)converter.isStarted());
        LoggingEvent event = this.makeLoggingEvent(null);
        event.setSequenceNumber(123L);
        Assertions.assertEquals((Object)"123", (Object)converter.convert((ILoggingEvent)event));
        StatusPrinter.print((Context)this.loggerContext);
    }

    @Test
    void dateConverterTest() {
        this.dateConverterChecker(List.of("STRICT", "GMT"), "2024-08-14T15:29:25,956");
        this.dateConverterChecker(List.of("ISO8601", "GMT"), "2024-08-14 15:29:25,956");
        this.dateConverterChecker(List.of("ISO8601", "UTC"), "2024-08-14 15:29:25,956");
        this.dateConverterChecker(List.of("yyyy-MM-EE", "UTC", "fr-CH"), "2024-08-mer.");
    }

    void dateConverterChecker(List<String> options, String expected) {
        DateConverter dateConverter = new DateConverter();
        dateConverter.setOptionList(options);
        dateConverter.setContext((Context)this.loggerContext);
        dateConverter.start();
        Assertions.assertTrue((boolean)dateConverter.isStarted());
        LoggingEvent event = this.makeLoggingEvent(null);
        long millis = 1723649365956L;
        Instant now = Instant.ofEpochMilli(millis);
        event.setInstant(now);
        String result = dateConverter.convert((ILoggingEvent)event);
        Assertions.assertEquals((Object)expected, (Object)result);
    }
}

