/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.spi;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.BasicContextListener;
import ch.qos.logback.classic.spi.LoggerContextListener;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ContextListenerTest {
    LoggerContext loggerContext;
    BasicContextListener listener;

    @BeforeEach
    public void setUp() throws Exception {
        this.loggerContext = new LoggerContext();
        this.loggerContext.start();
        this.listener = new BasicContextListener();
        this.loggerContext.addListener((LoggerContextListener)this.listener);
    }

    @Test
    public void testNotifyOnReset() {
        this.loggerContext.reset();
        Assertions.assertEquals((Object)((Object)BasicContextListener.UpdateType.RESET), (Object)((Object)this.listener.updateType));
        Assertions.assertEquals((Object)this.listener.context, (Object)this.loggerContext);
    }

    @Test
    public void testResistantListener_NotifyOnStop() {
        this.listener.setResetResistant(true);
        this.loggerContext.stop();
        Assertions.assertEquals((Object)((Object)BasicContextListener.UpdateType.STOP), (Object)((Object)this.listener.updateType));
        Assertions.assertEquals((Object)this.listener.context, (Object)this.loggerContext);
    }

    @Test
    public void testNotResistantListener_NotifyOnStop() {
        this.loggerContext.stop();
        Assertions.assertEquals((Object)((Object)BasicContextListener.UpdateType.RESET), (Object)((Object)this.listener.updateType));
        Assertions.assertEquals((Object)this.listener.context, (Object)this.loggerContext);
    }

    @Test
    public void testNotifyOnStart() {
        this.loggerContext.start();
        Assertions.assertEquals((Object)((Object)BasicContextListener.UpdateType.START), (Object)((Object)this.listener.updateType));
        Assertions.assertEquals((Object)this.listener.context, (Object)this.loggerContext);
    }

    void checkLevelChange(String loggerName, Level level) {
        Logger logger = this.loggerContext.getLogger(loggerName);
        logger.setLevel(level);
        Assertions.assertEquals((Object)((Object)BasicContextListener.UpdateType.LEVEL_CHANGE), (Object)((Object)this.listener.updateType));
        Assertions.assertEquals((Object)this.listener.logger, (Object)logger);
        Assertions.assertEquals((Object)this.listener.level, (Object)level);
    }

    @Test
    public void testLevelChange() {
        this.checkLevelChange("a", Level.INFO);
        this.checkLevelChange("a.b", Level.ERROR);
        this.checkLevelChange("a.b.c", Level.DEBUG);
    }
}

