/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core;

import ch.qos.logback.core.Appender;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.FilterAttachable;
import ch.qos.logback.core.spi.FilterAttachableImpl;
import ch.qos.logback.core.status.WarnStatus;

public abstract class AppenderBase
extends ContextAwareBase
implements Appender,
FilterAttachable {
    protected boolean started = false;
    private boolean guard = false;
    protected String name;
    private FilterAttachableImpl fai = new FilterAttachableImpl();
    private int statusRepeatCount = 0;
    static final int ALLOWED_REPEATS = 3;

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void doAppend(Object eventObject) {
        if (this.guard) {
            return;
        }
        try {
            this.guard = true;
            if (!this.started) {
                if (this.statusRepeatCount++ < 3) {
                    this.addStatus(new WarnStatus("Attempted to append to non started appender [" + this.name + "].", this));
                }
                return;
            }
            if (this.getFilterChainDecision(eventObject) == -1) {
                return;
            }
            this.append(eventObject);
        }
        finally {
            this.guard = false;
        }
    }

    protected abstract void append(Object var1);

    public void setName(String name) {
        this.name = name;
    }

    public void start() {
        this.started = true;
    }

    public void stop() {
        this.started = false;
    }

    public boolean isStarted() {
        return this.started;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.name + "]";
    }

    public void addFilter(Filter newFilter) {
        this.fai.addFilter(newFilter);
    }

    public Filter getFirstFilter() {
        return this.fai.getFirstFilter();
    }

    public void clearAllFilters() {
        this.fai.clearAllFilters();
    }

    public int getFilterChainDecision(Object event) {
        return this.fai.getFilterChainDecision(event);
    }
}

