/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.action.AppenderAction;
import ch.qos.logback.core.joran.action.AppenderRefAction;
import ch.qos.logback.core.joran.action.ConversionRuleAction;
import ch.qos.logback.core.joran.action.NestedComponentIA;
import ch.qos.logback.core.joran.action.NestedSimplePropertyIA;
import ch.qos.logback.core.joran.action.NewRuleAction;
import ch.qos.logback.core.joran.action.ParamAction;
import ch.qos.logback.core.joran.action.RepositoryPropertyAction;
import ch.qos.logback.core.joran.action.SubstitutionPropertyAction;
import ch.qos.logback.core.joran.spi.ExecutionContext;
import ch.qos.logback.core.joran.spi.Interpreter;
import ch.qos.logback.core.joran.spi.Pattern;
import ch.qos.logback.core.joran.spi.RuleStore;
import ch.qos.logback.core.joran.spi.SimpleRuleStore;
import ch.qos.logback.core.spi.ContextAwareBase;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public abstract class JoranConfiguratorBase
extends ContextAwareBase {
    Interpreter joranInterpreter;
    boolean listAppnderAttached = false;

    public final void doConfigure(URL url) {
        try {
            InputStream in = url.openStream();
            this.doConfigure(in);
            in.close();
        }
        catch (IOException ioe) {
            String errMsg = "Could not open URL [" + url + "].";
            this.addError(errMsg, ioe);
        }
    }

    public final void doConfigure(String filename) {
        this.doConfigure(new File(filename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doConfigure(File file) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            this.doConfigure(fis);
        }
        catch (IOException ioe) {
            String errMsg = "Could not open [" + file.getName() + "].";
            this.addError(errMsg, ioe);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ioe) {
                    this.addError("Could not close [" + file.getName() + "].", ioe);
                }
            }
        }
    }

    public final void doConfigure(InputStream inputStream) {
        this.doConfigure(new InputSource(inputStream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doConfigure(InputSource inputSource) {
        this.selfInitialize(this.context);
        ExecutionContext ec = this.joranInterpreter.getExecutionContext();
        SAXParser saxParser = null;
        try {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setValidating(false);
            spf.setNamespaceAware(true);
            saxParser = spf.newSAXParser();
        }
        catch (Exception pce) {
            String errMsg = "Parser configuration error occured";
            ec.addError(errMsg, pce);
            return;
        }
        try {
            saxParser.parse(inputSource, (DefaultHandler)this.joranInterpreter);
        }
        catch (IOException ie) {
            String errMsg = "I/O error occurred while parsing xml file";
            ec.addError("I/O error occurred while parsing xml file", ie);
        }
        catch (Exception ex) {
            String errMsg = "Problem parsing XML document. See previously reported errors. Abandoning all further processing.";
            this.addError("Problem parsing XML document. See previously reported errors. Abandoning all further processing.", ex);
            return;
        }
    }

    public List getErrorList() {
        return null;
    }

    public abstract void addInstanceRules(RuleStore var1);

    protected void selfInitialize(Context context) {
        SimpleRuleStore rs = new SimpleRuleStore(context);
        this.addInstanceRules(rs);
        rs.addRule(new Pattern("configuration/substitutionProperty"), new SubstitutionPropertyAction());
        rs.addRule(new Pattern("configuration/repositoryProperty"), new RepositoryPropertyAction());
        rs.addRule(new Pattern("configuration/conversionRule"), new ConversionRuleAction());
        rs.addRule(new Pattern("configuration/appender"), new AppenderAction());
        rs.addRule(new Pattern("configuration/appender/appender-ref"), new AppenderRefAction());
        rs.addRule(new Pattern("configuration/newRule"), new NewRuleAction());
        rs.addRule(new Pattern("*/param"), new ParamAction());
        this.joranInterpreter = new Interpreter(rs);
        ExecutionContext ec = this.joranInterpreter.getExecutionContext();
        ec.setContext(context);
        NestedComponentIA nestedIA = new NestedComponentIA();
        nestedIA.setContext(context);
        this.joranInterpreter.addImplicitAction(nestedIA);
        NestedSimplePropertyIA nestedSimpleIA = new NestedSimplePropertyIA();
        nestedIA.setContext(context);
        this.joranInterpreter.addImplicitAction(nestedSimpleIA);
        Map<String, Object> omap = ec.getObjectMap();
        omap.put("APPENDER_BAG", new HashMap());
        omap.put("FILTER_CHAIN_BAG", new HashMap());
    }

    public ExecutionContext getExecutionContext() {
        return this.joranInterpreter.getExecutionContext();
    }
}

