/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.action;

import ch.qos.logback.core.joran.action.ImplicitAction;
import ch.qos.logback.core.joran.action.ImplicitActionData;
import ch.qos.logback.core.joran.spi.ExecutionContext;
import ch.qos.logback.core.joran.spi.Pattern;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.LifeCycle;
import ch.qos.logback.core.util.Loader;
import ch.qos.logback.core.util.OptionHelper;
import ch.qos.logback.core.util.PropertySetter;
import java.util.Stack;
import org.xml.sax.Attributes;

public class NestedComponentIA
extends ImplicitAction {
    Stack<ImplicitActionData> actionDataStack = new Stack();

    public boolean isApplicable(Pattern pattern, Attributes attributes, ExecutionContext ec) {
        String nestedElementTagName = pattern.peekLast();
        Object o = ec.peekObject();
        PropertySetter parentBean = new PropertySetter(o);
        int containmentType = parentBean.canContainComponent(nestedElementTagName);
        switch (containmentType) {
            case 0: {
                return false;
            }
            case 1: 
            case 3: {
                ImplicitActionData ad = new ImplicitActionData(parentBean, containmentType);
                this.actionDataStack.push(ad);
                return true;
            }
        }
        this.addError("PropertySetter.canContainComponent returned " + containmentType);
        return false;
    }

    public void begin(ExecutionContext ec, String localName, Attributes attributes) {
        ImplicitActionData actionData = this.actionDataStack.peek();
        String className = attributes.getValue("class");
        if (OptionHelper.isEmpty(className = ec.subst(className))) {
            actionData.inError = true;
            String errMsg = "No class name attribute in <" + localName + ">";
            this.addError(errMsg);
            return;
        }
        try {
            actionData.nestedComponent = Loader.loadClass(className).newInstance();
            if (actionData.nestedComponent instanceof ContextAware) {
                ((ContextAware)actionData.nestedComponent).setContext(this.context);
            }
            ec.pushObject(actionData.nestedComponent);
        }
        catch (Exception oops) {
            actionData.inError = true;
            String msg = "Could not create component <" + localName + ">.";
            this.addError(msg);
        }
    }

    public void end(ExecutionContext ec, String tagName) {
        Object o;
        ImplicitActionData actionData = this.actionDataStack.pop();
        if (actionData.inError) {
            return;
        }
        if (actionData.nestedComponent instanceof LifeCycle) {
            ((LifeCycle)actionData.nestedComponent).start();
        }
        if ((o = ec.peekObject()) != actionData.nestedComponent) {
            this.addWarn("The object on the top the of the stack is not the component pushed earlier.");
        } else {
            ec.popObject();
            switch (actionData.containmentType) {
                case 1: {
                    actionData.parentBean.setComponent(tagName, actionData.nestedComponent);
                    break;
                }
                case 3: {
                    actionData.parentBean.addComponent(tagName, actionData.nestedComponent);
                }
            }
        }
    }
}

