/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.appender;

import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.appender.AbstractAppenderTest;
import ch.qos.logback.core.layout.DummyLayout;
import ch.qos.logback.core.layout.NopLayout;
import ch.qos.logback.core.util.TeeOutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import junit.framework.Test;
import junit.framework.TestSuite;

public class ConsoleAppenderTest
extends AbstractAppenderTest {
    TeeOutputStream tee;
    PrintStream original;

    public ConsoleAppenderTest(String arg) {
        super(arg);
    }

    protected void setUp() throws Exception {
        this.original = System.out;
        this.tee = new TeeOutputStream(this.original);
        System.setOut(new PrintStream(this.tee));
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        System.setOut(this.original);
    }

    protected AppenderBase getAppender() {
        return new ConsoleAppender();
    }

    protected AppenderBase getConfiguredAppender() {
        ConsoleAppender ca = new ConsoleAppender();
        ca.setLayout((Layout)new NopLayout());
        ca.start();
        return ca;
    }

    public void testBasic() {
        ConsoleAppender ca = (ConsoleAppender)this.getAppender();
        ca.setLayout((Layout)new DummyLayout());
        ca.start();
        ca.doAppend(new Object());
        ConsoleAppenderTest.assertEquals((String)DummyLayout.DUMMY, (String)this.tee.toString());
    }

    public void testOpen() {
        ConsoleAppender ca = (ConsoleAppender)this.getAppender();
        DummyLayout dummyLayout = new DummyLayout();
        dummyLayout.setHeader("open");
        ca.setLayout((Layout)dummyLayout);
        ca.start();
        ca.doAppend(new Object());
        ca.stop();
        ConsoleAppenderTest.assertEquals((String)("open" + Layout.LINE_SEP + DummyLayout.DUMMY), (String)this.tee.toString());
    }

    public void testClose() {
        ConsoleAppender ca = (ConsoleAppender)this.getAppender();
        DummyLayout dummyLayout = new DummyLayout();
        dummyLayout.setFooter("closed");
        ca.setLayout((Layout)dummyLayout);
        ca.start();
        ca.doAppend(new Object());
        ca.stop();
        ConsoleAppenderTest.assertEquals((String)(DummyLayout.DUMMY + "closed"), (String)this.tee.toString());
    }

    public void testUTF16BE() throws UnsupportedEncodingException {
        ConsoleAppender ca = (ConsoleAppender)this.getAppender();
        ca.setLayout((Layout)new DummyLayout());
        String encodingName = "UTF-16BE";
        ca.setEncoding(encodingName);
        ca.start();
        ca.doAppend(new Object());
        ConsoleAppenderTest.assertEquals((String)DummyLayout.DUMMY, (String)new String(this.tee.toByteArray(), encodingName));
    }

    public static Test xxsuite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(ConsoleAppenderTest.class);
        return suite;
    }
}

