/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern.parser;

import ch.qos.logback.core.pattern.FormatInfo;
import ch.qos.logback.core.pattern.parser.CompositeNode;
import ch.qos.logback.core.pattern.parser.FormattingNode;
import ch.qos.logback.core.pattern.parser.KeywordNode;
import ch.qos.logback.core.pattern.parser.Node;
import ch.qos.logback.core.pattern.parser.Parser;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class ParserTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public ParserTest(String arg0) {
        super(arg0);
    }

    public void testBasic() throws Exception {
        Parser p = new Parser("hello");
        Node t = p.parse();
        ParserTest.assertEquals((int)0, (int)t.getType());
        ParserTest.assertEquals((Object)"hello", (Object)t.getValue());
    }

    public void testKeyword() throws Exception {
        Parser p = new Parser("hello%xyz");
        Node t = p.parse();
        Node witness = new Node(0, (Object)"hello");
        witness.next = new KeywordNode((Object)"xyz");
        ParserTest.assertEquals((Object)witness, (Object)t);
        p = new Parser("hello%xyz{x}");
        t = p.parse();
        witness = new Node(0, (Object)"hello");
        KeywordNode n = new KeywordNode((Object)"xyz");
        ArrayList<String> optionList = new ArrayList<String>();
        optionList.add("x");
        n.setOptions(optionList);
        witness.next = n;
        ParserTest.assertEquals((Object)witness, (Object)t);
    }

    public void testComposite() throws Exception {
        System.out.println();
        System.out.println("testRecursive");
        Parser p = new Parser("hello%(%child)");
        Node t = p.parse();
        Node witness = new Node(0, (Object)"hello");
        CompositeNode composite = new CompositeNode();
        KeywordNode child = new KeywordNode((Object)"child");
        composite.setChildNode((Node)child);
        witness.next = composite;
        System.out.println("w:" + witness);
        System.out.println(t);
        ParserTest.assertEquals((Object)witness, (Object)t);
        System.out.println("testRecursive part 2");
        p = new Parser("hello%(%child )");
        t = p.parse();
        witness = new Node(0, (Object)"hello");
        composite = new CompositeNode();
        child = new KeywordNode((Object)"child");
        composite.setChildNode((Node)child);
        witness.next = composite;
        child.next = new Node(0, (Object)" ");
        ParserTest.assertEquals((Object)witness, (Object)t);
        p = new Parser("hello%(%child %h)");
        t = p.parse();
        witness = new Node(0, (Object)"hello");
        composite = new CompositeNode();
        child = new KeywordNode((Object)"child");
        composite.setChildNode((Node)child);
        child.next = new Node(0, (Object)" ");
        child.next.next = new KeywordNode((Object)"h");
        witness.next = composite;
        ParserTest.assertEquals((Object)witness, (Object)t);
        p = new Parser("hello%(%child %h) %m");
        t = p.parse();
        witness = new Node(0, (Object)"hello");
        composite = new CompositeNode();
        child = new KeywordNode((Object)"child");
        composite.setChildNode((Node)child);
        child.next = new Node(0, (Object)" ");
        child.next.next = new KeywordNode((Object)"h");
        witness.next = composite;
        composite.next = new Node(0, (Object)" ");
        composite.next.next = new KeywordNode((Object)"m");
        ParserTest.assertEquals((Object)witness, (Object)t);
        p = new Parser("hello%( %child \\(%h\\) ) %m");
        t = p.parse();
        witness = new Node(0, (Object)"hello");
        composite = new CompositeNode();
        child = new Node(0, (Object)" ");
        composite.setChildNode((Node)child);
        KeywordNode c = child;
        c.next = new KeywordNode((Object)"child");
        c = c.next;
        c.next = new Node(0, (Object)" (");
        c = c.next;
        c.next = new KeywordNode((Object)"h");
        c = c.next;
        c.next = new Node(0, (Object)") ");
        c = c.next;
        witness.next = composite;
        composite.next = new Node(0, (Object)" ");
        composite.next.next = new KeywordNode((Object)"m");
        ParserTest.assertEquals((Object)witness, (Object)t);
    }

    public void testNested() throws Exception {
        Parser p = new Parser("%top %(%child%(%h))");
        Node t = p.parse();
        KeywordNode witness = new KeywordNode((Object)"top");
        Node w = witness.next = new Node(0, (Object)" ");
        CompositeNode composite = new CompositeNode();
        w = w.next = composite;
        KeywordNode child = new KeywordNode((Object)"child");
        composite.setChildNode((Node)child);
        composite = new CompositeNode();
        child.next = composite;
        composite.setChildNode((Node)new KeywordNode((Object)"h"));
        ParserTest.assertEquals((Object)witness, (Object)t);
    }

    public void testFormattingInfo() throws Exception {
        Parser p = new Parser("%45x");
        Node t = p.parse();
        KeywordNode witness = new KeywordNode((Object)"x");
        witness.setFormatInfo(new FormatInfo(45, Integer.MAX_VALUE));
        ParserTest.assertEquals((Object)witness, (Object)t);
        p = new Parser("%4.5x");
        t = p.parse();
        witness = new KeywordNode((Object)"x");
        witness.setFormatInfo(new FormatInfo(4, 5));
        ParserTest.assertEquals((Object)witness, (Object)t);
        p = new Parser("%-4.5x");
        t = p.parse();
        witness = new KeywordNode((Object)"x");
        witness.setFormatInfo(new FormatInfo(4, 5, false, true));
        ParserTest.assertEquals((Object)witness, (Object)t);
        p = new Parser("%-4.-5x");
        t = p.parse();
        witness = new KeywordNode((Object)"x");
        witness.setFormatInfo(new FormatInfo(4, 5, false, false));
        ParserTest.assertEquals((Object)witness, (Object)t);
        p = new Parser("%-4.5x %12y");
        t = p.parse();
        witness = new KeywordNode((Object)"x");
        witness.setFormatInfo(new FormatInfo(4, 5, false, true));
        Node n = witness.next = new Node(0, (Object)" ");
        n = n.next = new KeywordNode((Object)"y");
        ((FormattingNode)n).setFormatInfo(new FormatInfo(12, Integer.MAX_VALUE));
        ParserTest.assertEquals((Object)witness, (Object)t);
    }

    public void testOptions() throws Exception {
        Parser p = new Parser("%45x{'test '}");
        Node t = p.parse();
        KeywordNode witness = new KeywordNode((Object)"x");
        witness.setFormatInfo(new FormatInfo(45, Integer.MAX_VALUE));
        ArrayList<String> ol = new ArrayList<String>();
        ol.add("test ");
        witness.setOptions(ol);
        ParserTest.assertEquals((Object)witness, (Object)t);
        p = new Parser("%45x{a, b}");
        t = p.parse();
        witness = new KeywordNode((Object)"x");
        witness.setFormatInfo(new FormatInfo(45, Integer.MAX_VALUE));
        ol = new ArrayList();
        ol.add("a");
        ol.add("b");
        witness.setOptions(ol);
        ParserTest.assertEquals((Object)witness, (Object)t);
    }

    public void testCompositeFormatting() throws Exception {
        System.out.println();
        System.out.println("testRecursive");
        Parser p = new Parser("hello%5(XYZ)");
        Node t = p.parse();
        Node witness = new Node(0, (Object)"hello");
        CompositeNode composite = new CompositeNode();
        composite.setFormatInfo(new FormatInfo(5, Integer.MAX_VALUE));
        Node child = new Node(0, (Object)"XYZ");
        composite.setChildNode(child);
        witness.next = composite;
        ParserTest.assertEquals((Object)witness, (Object)t);
    }

    public static Test Xsuite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new ParserTest("testFormattingInfo"));
        return suite;
    }
}

