/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.rolling;

import ch.qos.logback.core.Layout;
import ch.qos.logback.core.layout.EchoLayout;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.util.Compare;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TimeBasedRollingTest
extends TestCase {
    static final String DATE_PATTERN = "yyyy-MM-dd_HH_mm_ss";
    EchoLayout layout = new EchoLayout();

    public TimeBasedRollingTest(String name) {
        super(name);
    }

    public void setUp() {
        File target = new File("src/test/output/test4.log");
        target.mkdirs();
        target.delete();
        target = new File("src/test/output/test5.log");
        target.mkdirs();
        target.delete();
        target = new File("src/test/output/test6.log");
        target.mkdirs();
        target.delete();
    }

    public void tearDown() {
    }

    public void test1() throws Exception {
        int i;
        RollingFileAppender rfa = new RollingFileAppender();
        rfa.setLayout((Layout)this.layout);
        TimeBasedRollingPolicy tbrp = new TimeBasedRollingPolicy();
        tbrp.setFileNamePattern("src/test/output/test1-%d{yyyy-MM-dd_HH_mm_ss}");
        tbrp.start();
        rfa.setRollingPolicy((RollingPolicy)tbrp);
        rfa.start();
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_PATTERN);
        String[] filenames = new String[3];
        Calendar cal = Calendar.getInstance();
        for (i = 0; i < 3; ++i) {
            filenames[i] = "src/test/output/test1-" + sdf.format(cal.getTime());
            cal.add(13, 1);
        }
        System.out.println("Waiting until next second and 100 millis.");
        this.delayUntilNextSecond(100);
        System.out.println("Done waiting.");
        for (i = 0; i < 3; ++i) {
            rfa.doAppend((Object)("Hello---" + i));
            Thread.sleep(500L);
        }
        for (i = 0; i < 3; ++i) {
            TimeBasedRollingTest.assertTrue((boolean)Compare.compare(filenames[i], "src/test/witness/rolling/tbr-test1." + i));
        }
    }

    public void test2() throws Exception {
        int i;
        int i2;
        RollingFileAppender rfa1 = new RollingFileAppender();
        rfa1.setLayout((Layout)this.layout);
        TimeBasedRollingPolicy tbrp1 = new TimeBasedRollingPolicy();
        tbrp1.setFileNamePattern("src/test/output/test2-%d{yyyy-MM-dd_HH_mm_ss}");
        tbrp1.start();
        rfa1.setRollingPolicy((RollingPolicy)tbrp1);
        rfa1.start();
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_PATTERN);
        String[] filenames = new String[3];
        Calendar cal = Calendar.getInstance();
        for (i2 = 0; i2 < 3; ++i2) {
            filenames[i2] = "src/test/output/test2-" + sdf.format(cal.getTime());
            cal.add(13, 1);
        }
        System.out.println("Waiting until next second and 100 millis.");
        this.delayUntilNextSecond(100);
        System.out.println("Done waiting.");
        for (i2 = 0; i2 <= 2; ++i2) {
            rfa1.doAppend((Object)("Hello---" + i2));
            Thread.sleep(500L);
        }
        rfa1.stop();
        RollingFileAppender rfa2 = new RollingFileAppender();
        rfa2.setLayout((Layout)this.layout);
        TimeBasedRollingPolicy tbrp2 = new TimeBasedRollingPolicy();
        tbrp2.setFileNamePattern("src/test/output/test2-%d{yyyy-MM-dd_HH_mm_ss}");
        tbrp2.start();
        rfa2.setRollingPolicy((RollingPolicy)tbrp2);
        rfa2.start();
        for (i = 0; i <= 2; ++i) {
            rfa2.doAppend((Object)("Hello---" + i));
            Thread.sleep(100L);
        }
        for (i = 0; i < 3; ++i) {
            TimeBasedRollingTest.assertTrue((boolean)Compare.compare(filenames[i], "src/test/witness/rolling/tbr-test2." + i));
        }
    }

    public void test3() throws Exception {
        int i;
        RollingFileAppender rfa = new RollingFileAppender();
        rfa.setLayout((Layout)this.layout);
        TimeBasedRollingPolicy tbrp = new TimeBasedRollingPolicy();
        tbrp.setFileNamePattern("src/test/output/test3-%d{yyyy-MM-dd_HH_mm_ss}.gz");
        tbrp.start();
        rfa.setRollingPolicy((RollingPolicy)tbrp);
        rfa.start();
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_PATTERN);
        String[] filenames = new String[4];
        Calendar cal = Calendar.getInstance();
        for (i = 0; i < 2; ++i) {
            filenames[i] = "src/test/output/test3-" + sdf.format(cal.getTime()) + ".gz";
            cal.add(13, 1);
        }
        filenames[3] = "src/test/output/test3-" + sdf.format(cal.getTime());
        System.out.println("Waiting until next second and 100 millis.");
        this.delayUntilNextSecond(100);
        System.out.println("Done waiting.");
        for (i = 0; i < 3; ++i) {
            rfa.doAppend((Object)("Hello---" + i));
            Thread.sleep(500L);
        }
        for (i = 0; i < 2; ++i) {
            TimeBasedRollingTest.assertTrue((boolean)Compare.gzCompare(filenames[i], "src/test/witness/rolling/tbr-test3." + i + ".gz"));
        }
        TimeBasedRollingTest.assertTrue((boolean)Compare.compare(filenames[3], "src/test/witness/rolling/tbr-test3.2"));
    }

    public void test4() throws Exception {
        int i;
        int i2;
        RollingFileAppender rfa1 = new RollingFileAppender();
        rfa1.setLayout((Layout)this.layout);
        TimeBasedRollingPolicy tbrp1 = new TimeBasedRollingPolicy();
        tbrp1.setActiveFileName("src/test/output/test4.log");
        tbrp1.setFileNamePattern("src/test/output/test4-%d{yyyy-MM-dd_HH_mm_ss}");
        tbrp1.start();
        rfa1.setRollingPolicy((RollingPolicy)tbrp1);
        rfa1.start();
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_PATTERN);
        String[] filenames = new String[3];
        Calendar cal = Calendar.getInstance();
        for (i2 = 0; i2 < 2; ++i2) {
            filenames[i2] = "src/test/output/test4-" + sdf.format(cal.getTime());
            cal.add(13, 1);
        }
        filenames[2] = "src/test/output/test4.log";
        System.out.println("Waiting until next second and 100 millis.");
        this.delayUntilNextSecond(100);
        System.out.println("Done waiting.");
        for (i2 = 0; i2 <= 2; ++i2) {
            rfa1.doAppend((Object)("Hello---" + i2));
            Thread.sleep(500L);
        }
        rfa1.stop();
        RollingFileAppender rfa2 = new RollingFileAppender();
        rfa2.setLayout((Layout)this.layout);
        TimeBasedRollingPolicy tbrp2 = new TimeBasedRollingPolicy();
        tbrp2.setFileNamePattern("src/test/output/test4-%d{yyyy-MM-dd_HH_mm_ss}");
        tbrp2.setActiveFileName("src/test/output/test4.log");
        tbrp2.start();
        rfa2.setRollingPolicy((RollingPolicy)tbrp2);
        rfa2.start();
        for (i = 0; i <= 2; ++i) {
            rfa2.doAppend((Object)("Hello---" + i));
            Thread.sleep(100L);
        }
        for (i = 0; i < 3; ++i) {
            TimeBasedRollingTest.assertTrue((boolean)Compare.compare(filenames[i], "src/test/witness/rolling/tbr-test4." + i));
        }
    }

    public void test5() throws Exception {
        int i;
        RollingFileAppender rfa = new RollingFileAppender();
        rfa.setLayout((Layout)this.layout);
        TimeBasedRollingPolicy tbrp = new TimeBasedRollingPolicy();
        tbrp.setFileNamePattern("src/test/output/test5-%d{yyyy-MM-dd_HH_mm_ss}");
        tbrp.setActiveFileName("src/test/output/test5.log");
        tbrp.start();
        rfa.setRollingPolicy((RollingPolicy)tbrp);
        rfa.start();
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_PATTERN);
        String[] filenames = new String[4];
        Calendar cal = Calendar.getInstance();
        for (i = 0; i < 2; ++i) {
            filenames[i] = "src/test/output/test5-" + sdf.format(cal.getTime());
            cal.add(13, 1);
        }
        filenames[2] = "src/test/output/test5.log";
        System.out.println("Waiting until next second and 100 millis.");
        this.delayUntilNextSecond(100);
        System.out.println("Done waiting.");
        for (i = 0; i < 3; ++i) {
            rfa.doAppend((Object)("Hello---" + i));
            Thread.sleep(500L);
        }
        for (i = 0; i < 3; ++i) {
            TimeBasedRollingTest.assertTrue((boolean)Compare.compare(filenames[i], "src/test/witness/rolling/tbr-test5." + i));
        }
    }

    public void test6() throws Exception {
        int i;
        RollingFileAppender rfa = new RollingFileAppender();
        rfa.setLayout((Layout)this.layout);
        TimeBasedRollingPolicy tbrp = new TimeBasedRollingPolicy();
        tbrp.setFileNamePattern("src/test/output/test6-%d{yyyy-MM-dd_HH_mm_ss}.gz");
        tbrp.setActiveFileName("src/test/output/test6.log");
        tbrp.start();
        rfa.setRollingPolicy((RollingPolicy)tbrp);
        rfa.start();
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_PATTERN);
        String[] filenames = new String[4];
        Calendar cal = Calendar.getInstance();
        for (i = 0; i < 2; ++i) {
            filenames[i] = "src/test/output/test6-" + sdf.format(cal.getTime()) + ".gz";
            cal.add(13, 1);
        }
        filenames[2] = "src/test/output/test6.log";
        System.out.println("Waiting until next second and 100 millis.");
        this.delayUntilNextSecond(100);
        System.out.println("Done waiting.");
        for (i = 0; i < 3; ++i) {
            rfa.doAppend((Object)("Hello---" + i));
            Thread.sleep(500L);
        }
        for (i = 0; i < 2; ++i) {
            TimeBasedRollingTest.assertTrue((boolean)Compare.gzCompare(filenames[i], "src/test/witness/rolling/tbr-test6." + i + ".gz"));
        }
        TimeBasedRollingTest.assertTrue((boolean)Compare.compare(filenames[2], "src/test/witness/rolling/tbr-test6.2"));
    }

    void delayUntilNextSecond(int millis) {
        long now = System.currentTimeMillis();
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(now));
        cal.set(14, millis);
        cal.add(13, 1);
        long next = cal.getTime().getTime();
        try {
            Thread.sleep(next - now);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    void delayUntilNextMinute(int seconds) {
        long now = System.currentTimeMillis();
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(now));
        cal.set(13, seconds);
        cal.add(12, 1);
        long next = cal.getTime().getTime();
        try {
            Thread.sleep(next - now);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(TimeBasedRollingTest.class);
        return suite;
    }
}

