/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.util;

import ch.qos.logback.core.util.Door;
import ch.qos.logback.core.util.House;
import ch.qos.logback.core.util.PropertySetter;
import junit.framework.TestCase;

public class PropertySetterTest
extends TestCase {
    public void testCanContainComponent() {
        House house = new House();
        PropertySetter setter = new PropertySetter((Object)house);
        PropertySetterTest.assertEquals((int)1, (int)setter.canContainComponent("door"));
        PropertySetterTest.assertEquals((int)2, (int)setter.canContainComponent("count"));
        PropertySetterTest.assertEquals((int)2, (int)setter.canContainComponent("Count"));
        PropertySetterTest.assertEquals((int)2, (int)setter.canContainComponent("name"));
        PropertySetterTest.assertEquals((int)2, (int)setter.canContainComponent("Name"));
        PropertySetterTest.assertEquals((int)2, (int)setter.canContainComponent("open"));
        PropertySetterTest.assertEquals((int)2, (int)setter.canContainComponent("Open"));
    }

    public void testSetProperty() {
        House house = new House();
        PropertySetter setter = new PropertySetter((Object)house);
        setter.setProperty("count", "10");
        setter.setProperty("name", "jack");
        setter.setProperty("open", "true");
        PropertySetterTest.assertEquals((int)10, (int)house.getCount());
        PropertySetterTest.assertEquals((String)"jack", (String)house.getName());
        PropertySetterTest.assertTrue((boolean)house.isOpen());
        house = new House();
        setter = new PropertySetter((Object)house);
        setter.setProperty("Count", "10");
        setter.setProperty("Name", "jack");
        setter.setProperty("Open", "true");
        PropertySetterTest.assertEquals((int)10, (int)house.getCount());
        PropertySetterTest.assertEquals((String)"jack", (String)house.getName());
        PropertySetterTest.assertTrue((boolean)house.isOpen());
    }

    public void testSetComponent() {
        House house = new House();
        Door door = new Door();
        PropertySetter setter = new PropertySetter((Object)house);
        setter.setComponent("door", (Object)door);
        PropertySetterTest.assertEquals((Object)door, (Object)house.getDoor());
    }
}

