/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.db;

import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.db.ConnectionSource;
import ch.qos.logback.core.db.DBHelper;
import ch.qos.logback.core.db.dialect.DBUtil;
import ch.qos.logback.core.db.dialect.SQLDialect;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DBAppenderBase
extends AppenderBase {
    protected static final String insertPropertiesSQL = "INSERT INTO  logging_event_property (event_id, mapped_key, mapped_value) VALUES (?, ?, ?)";
    protected static final String insertExceptionSQL = "INSERT INTO  logging_event_exception (event_id, i, trace_line) VALUES (?, ?, ?)";
    protected static final String insertSQL;
    protected static final Method GET_GENERATED_KEYS_METHOD;
    protected ConnectionSource connectionSource;
    protected boolean cnxSupportsGetGeneratedKeys = false;
    protected boolean cnxSupportsBatchUpdates = false;
    protected SQLDialect sqlDialect;

    @Override
    public void start() {
        if (this.connectionSource == null) {
            throw new IllegalStateException("DBAppender cannot function without a connection source");
        }
        this.sqlDialect = DBUtil.getDialectFromCode(this.connectionSource.getSQLDialectCode());
        this.cnxSupportsGetGeneratedKeys = GET_GENERATED_KEYS_METHOD != null ? this.connectionSource.supportsGetGeneratedKeys() : false;
        this.cnxSupportsBatchUpdates = this.connectionSource.supportsBatchUpdates();
        if (!this.cnxSupportsGetGeneratedKeys && this.sqlDialect == null) {
            throw new IllegalStateException("DBAppender cannot function if the JDBC driver does not support getGeneratedKeys method *and* without a specific SQL dialect");
        }
        super.start();
    }

    public ConnectionSource getConnectionSource() {
        return this.connectionSource;
    }

    public void setConnectionSource(ConnectionSource connectionSource) {
        this.connectionSource = connectionSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void append(Object eventObject) {
        Connection connection = null;
        try {
            connection = this.connectionSource.getConnection();
            connection.setAutoCommit(false);
            PreparedStatement insertStatement = connection.prepareStatement(insertSQL);
            this.subAppend(eventObject, connection, insertStatement);
            if (insertStatement != null) {
                insertStatement.close();
                insertStatement = null;
            }
            connection.commit();
        }
        catch (Throwable sqle) {
            this.addError("problem appending event", sqle);
        }
        finally {
            DBHelper.closeConnection(connection);
        }
    }

    protected abstract void subAppend(Object var1, Connection var2, PreparedStatement var3) throws Throwable;

    protected int getEventId(PreparedStatement insertStatement, Connection connection) throws SQLException, InvocationTargetException {
        ResultSet rs = null;
        Statement idStatement = null;
        boolean gotGeneratedKeys = false;
        if (this.cnxSupportsGetGeneratedKeys) {
            try {
                rs = (ResultSet)GET_GENERATED_KEYS_METHOD.invoke((Object)insertStatement, (Object[])null);
                gotGeneratedKeys = true;
            }
            catch (InvocationTargetException ex) {
                Throwable target = ex.getTargetException();
                if (target instanceof SQLException) {
                    throw (SQLException)target;
                }
                throw ex;
            }
            catch (IllegalAccessException ex) {
                this.addWarn("IllegalAccessException invoking PreparedStatement.getGeneratedKeys", ex);
            }
        }
        if (!gotGeneratedKeys) {
            insertStatement.close();
            insertStatement = null;
            idStatement = connection.createStatement();
            idStatement.setMaxRows(1);
            rs = idStatement.executeQuery(this.sqlDialect.getSelectInsertId());
        }
        rs.next();
        int eventId = rs.getInt(1);
        rs.close();
        if (idStatement != null) {
            idStatement.close();
            idStatement = null;
        }
        return eventId;
    }

    protected void insertProperties(Map<String, String> mergedMap, Connection connection, int eventId) throws SQLException {
        Set<String> propertiesKeys = mergedMap.keySet();
        if (propertiesKeys.size() > 0) {
            PreparedStatement insertPropertiesStatement = connection.prepareStatement(insertPropertiesSQL);
            for (String key : propertiesKeys) {
                String value = mergedMap.get(key);
                insertPropertiesStatement.setInt(1, eventId);
                insertPropertiesStatement.setString(2, key);
                insertPropertiesStatement.setString(3, value);
                if (this.cnxSupportsBatchUpdates) {
                    insertPropertiesStatement.addBatch();
                    continue;
                }
                insertPropertiesStatement.execute();
            }
            if (this.cnxSupportsBatchUpdates) {
                insertPropertiesStatement.executeBatch();
            }
            insertPropertiesStatement.close();
            insertPropertiesStatement = null;
        }
    }

    protected void insertThrowable(String[] strRep, Connection connection, int eventId) throws SQLException {
        PreparedStatement insertExceptionStatement = connection.prepareStatement(insertExceptionSQL);
        for (short i = 0; i < strRep.length; i = (short)(i + 1)) {
            insertExceptionStatement.setInt(1, eventId);
            insertExceptionStatement.setShort(2, i);
            insertExceptionStatement.setString(3, strRep[i]);
            if (this.cnxSupportsBatchUpdates) {
                insertExceptionStatement.addBatch();
                continue;
            }
            insertExceptionStatement.execute();
        }
        if (this.cnxSupportsBatchUpdates) {
            insertExceptionStatement.executeBatch();
        }
        insertExceptionStatement.close();
        insertExceptionStatement = null;
    }

    @Override
    public void stop() {
        super.stop();
    }

    @Override
    public Layout getLayout() {
        return null;
    }

    @Override
    public void setLayout(Layout layout) {
    }

    static {
        Method getGeneratedKeysMethod;
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO logging_event (");
        sql.append("timestmp, ");
        sql.append("formatted_message, ");
        sql.append("logger_name, ");
        sql.append("level_string, ");
        sql.append("thread_name, ");
        sql.append("reference_flag, ");
        sql.append("caller_filename, ");
        sql.append("caller_class, ");
        sql.append("caller_method, ");
        sql.append("caller_line) ");
        sql.append(" VALUES (?, ?, ? ,?, ?, ?, ?, ?, ?,?)");
        insertSQL = sql.toString();
        try {
            getGeneratedKeysMethod = PreparedStatement.class.getMethod("getGeneratedKeys", null);
        }
        catch (Exception ex) {
            getGeneratedKeysMethod = null;
        }
        GET_GENERATED_KEYS_METHOD = getGeneratedKeysMethod;
    }
}

