/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.action;

import ch.qos.logback.core.joran.action.ImplicitAction;
import ch.qos.logback.core.joran.action.ImplicitActionData;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.joran.spi.Pattern;
import ch.qos.logback.core.spi.ContextAware;
import ch.qos.logback.core.spi.LifeCycle;
import ch.qos.logback.core.util.Loader;
import ch.qos.logback.core.util.OptionHelper;
import ch.qos.logback.core.util.PropertySetter;
import java.util.Stack;
import org.xml.sax.Attributes;

public class NestedComponentIA
extends ImplicitAction {
    Stack<ImplicitActionData> actionDataStack = new Stack();

    public boolean isApplicable(Pattern pattern, Attributes attributes, InterpretationContext ec) {
        String nestedElementTagName = pattern.peekLast();
        if (ec.isEmpty()) {
            return false;
        }
        Object o = ec.peekObject();
        PropertySetter parentBean = new PropertySetter(o);
        parentBean.setContext(this.context);
        int containmentType = parentBean.canContainComponent(nestedElementTagName);
        switch (containmentType) {
            case 0: 
            case 2: {
                return false;
            }
            case 1: 
            case 3: {
                this.addInfo("is dmmed applicable for " + pattern);
                ImplicitActionData ad = new ImplicitActionData(parentBean, containmentType);
                this.actionDataStack.push(ad);
                return true;
            }
        }
        this.addError("PropertySetter.canContainComponent returned " + containmentType);
        return false;
    }

    public void begin(InterpretationContext ec, String localName, Attributes attributes) {
        ImplicitActionData actionData = this.actionDataStack.peek();
        String className = attributes.getValue("class");
        if (OptionHelper.isEmpty(className = ec.subst(className))) {
            actionData.inError = true;
            String errMsg = "No class name attribute in <" + localName + ">";
            this.addError(errMsg);
            return;
        }
        try {
            actionData.nestedComponent = Loader.loadClass(className).newInstance();
            if (actionData.nestedComponent instanceof ContextAware) {
                ((ContextAware)actionData.nestedComponent).setContext(this.context);
            }
            this.addInfo("Pushing component <" + localName + "> on top of the object stack.");
            ec.pushObject(actionData.nestedComponent);
        }
        catch (Exception oops) {
            actionData.inError = true;
            String msg = "Could not create component <" + localName + "> of type [" + className + "]";
            this.addError(msg, oops);
        }
    }

    public void end(InterpretationContext ec, String tagName) {
        Object o;
        ImplicitActionData actionData = this.actionDataStack.pop();
        if (actionData.inError) {
            return;
        }
        if (actionData.nestedComponent instanceof LifeCycle) {
            ((LifeCycle)actionData.nestedComponent).start();
        }
        if ((o = ec.peekObject()) != actionData.nestedComponent) {
            this.addError("The object on the top the of the stack is not the component pushed earlier.");
        } else {
            ec.popObject();
            switch (actionData.containmentType) {
                case 1: {
                    actionData.parentBean.setComponent(tagName, actionData.nestedComponent);
                    break;
                }
                case 3: {
                    actionData.parentBean.addComponent(tagName, actionData.nestedComponent);
                }
            }
        }
    }
}

