/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.action;

import ch.qos.logback.core.joran.action.ImplicitAction;
import ch.qos.logback.core.joran.action.ImplicitActionData;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.joran.spi.Pattern;
import ch.qos.logback.core.util.PropertySetter;
import java.util.Stack;
import org.xml.sax.Attributes;

public class NestedSimplePropertyIA
extends ImplicitAction {
    Stack<ImplicitActionData> actionDataStack = new Stack();

    public boolean isApplicable(Pattern pattern, Attributes attributes, InterpretationContext ec) {
        String nestedElementTagName = pattern.peekLast();
        if (ec.isEmpty()) {
            return false;
        }
        Object o = ec.peekObject();
        PropertySetter parentBean = new PropertySetter(o);
        parentBean.setContext(this.context);
        int containmentType = parentBean.canContainComponent(nestedElementTagName);
        switch (containmentType) {
            case 0: 
            case 1: 
            case 3: {
                return false;
            }
            case 2: {
                ImplicitActionData ad = new ImplicitActionData(parentBean, containmentType);
                ad.propertyName = nestedElementTagName;
                this.actionDataStack.push(ad);
                return true;
            }
        }
        this.addError("PropertySetter.canContainComponent returned " + containmentType);
        return false;
    }

    public void begin(InterpretationContext ec, String localName, Attributes attributes) {
    }

    public void body(InterpretationContext ec, String body) {
        String finalBody = ec.subst(body);
        ImplicitActionData actionData = this.actionDataStack.peek();
        actionData.parentBean.setProperty(actionData.propertyName, finalBody);
    }

    public void end(InterpretationContext ec, String tagName) {
        this.actionDataStack.pop();
    }
}

